/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.GroupIdInformationProperties;
import java.io.IOException;

public final class GroupIdInformationInner
implements JsonSerializable<GroupIdInformationInner> {
    private String id;
    private String name;
    private String type;
    private GroupIdInformationProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(GroupIdInformationInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public GroupIdInformationProperties properties() {
        return this.properties;
    }

    public GroupIdInformationInner withProperties(GroupIdInformationProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model GroupIdInformationInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static GroupIdInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (GroupIdInformationInner)jsonReader.readObject(reader -> {
            GroupIdInformationInner deserializedGroupIdInformationInner = new GroupIdInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedGroupIdInformationInner.properties = GroupIdInformationProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedGroupIdInformationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGroupIdInformationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGroupIdInformationInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGroupIdInformationInner;
        });
    }
}

