/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.ArmIdentity;
import com.azure.resourcemanager.iothub.models.IotHubProperties;
import com.azure.resourcemanager.iothub.models.IotHubSkuInfo;
import java.io.IOException;
import java.util.Map;

public final class IotHubDescriptionInner
extends Resource {
    private String etag;
    private IotHubProperties properties;
    private IotHubSkuInfo sku;
    private ArmIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubDescriptionInner.class);

    public String etag() {
        return this.etag;
    }

    public IotHubDescriptionInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public IotHubProperties properties() {
        return this.properties;
    }

    public IotHubDescriptionInner withProperties(IotHubProperties properties) {
        this.properties = properties;
        return this;
    }

    public IotHubSkuInfo sku() {
        return this.sku;
    }

    public IotHubDescriptionInner withSku(IotHubSkuInfo sku) {
        this.sku = sku;
        return this;
    }

    public ArmIdentity identity() {
        return this.identity;
    }

    public IotHubDescriptionInner withIdentity(ArmIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public IotHubDescriptionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IotHubDescriptionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model IotHubDescriptionInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static IotHubDescriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubDescriptionInner)((Object)jsonReader.readObject(reader -> {
            IotHubDescriptionInner deserializedIotHubDescriptionInner = new IotHubDescriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIotHubDescriptionInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.sku = IotHubSkuInfo.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.properties = IotHubProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.identity = ArmIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedIotHubDescriptionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubDescriptionInner;
        }));
    }
}

