/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.IotHubCapacity;
import com.azure.resourcemanager.iothub.models.IotHubSkuInfo;
import java.io.IOException;

public final class IotHubSkuDescriptionInner
implements JsonSerializable<IotHubSkuDescriptionInner> {
    private String resourceType;
    private IotHubSkuInfo sku;
    private IotHubCapacity capacity;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubSkuDescriptionInner.class);

    public String resourceType() {
        return this.resourceType;
    }

    public IotHubSkuInfo sku() {
        return this.sku;
    }

    public IotHubSkuDescriptionInner withSku(IotHubSkuInfo sku) {
        this.sku = sku;
        return this;
    }

    public IotHubCapacity capacity() {
        return this.capacity;
    }

    public IotHubSkuDescriptionInner withCapacity(IotHubCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model IotHubSkuDescriptionInner"));
        }
        this.sku().validate();
        if (this.capacity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capacity in model IotHubSkuDescriptionInner"));
        }
        this.capacity().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static IotHubSkuDescriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubSkuDescriptionInner)jsonReader.readObject(reader -> {
            IotHubSkuDescriptionInner deserializedIotHubSkuDescriptionInner = new IotHubSkuDescriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedIotHubSkuDescriptionInner.sku = IotHubSkuInfo.fromJson(reader);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedIotHubSkuDescriptionInner.capacity = IotHubCapacity.fromJson(reader);
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedIotHubSkuDescriptionInner.resourceType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubSkuDescriptionInner;
        });
    }
}

