/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.JobStatus;
import com.azure.resourcemanager.iothub.models.JobType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class JobResponseInner
implements JsonSerializable<JobResponseInner> {
    private String jobId;
    private DateTimeRfc1123 startTimeUtc;
    private DateTimeRfc1123 endTimeUtc;
    private JobType type;
    private JobStatus status;
    private String failureReason;
    private String statusMessage;
    private String parentJobId;

    public String jobId() {
        return this.jobId;
    }

    public OffsetDateTime startTimeUtc() {
        if (this.startTimeUtc == null) {
            return null;
        }
        return this.startTimeUtc.getDateTime();
    }

    public OffsetDateTime endTimeUtc() {
        if (this.endTimeUtc == null) {
            return null;
        }
        return this.endTimeUtc.getDateTime();
    }

    public JobType type() {
        return this.type;
    }

    public JobStatus status() {
        return this.status;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String parentJobId() {
        return this.parentJobId;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static JobResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobResponseInner)jsonReader.readObject(reader -> {
            JobResponseInner deserializedJobResponseInner = new JobResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedJobResponseInner.jobId = reader.getString();
                    continue;
                }
                if ("startTimeUtc".equals(fieldName)) {
                    deserializedJobResponseInner.startTimeUtc = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("endTimeUtc".equals(fieldName)) {
                    deserializedJobResponseInner.endTimeUtc = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobResponseInner.type = JobType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobResponseInner.status = JobStatus.fromString(reader.getString());
                    continue;
                }
                if ("failureReason".equals(fieldName)) {
                    deserializedJobResponseInner.failureReason = reader.getString();
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedJobResponseInner.statusMessage = reader.getString();
                    continue;
                }
                if ("parentJobId".equals(fieldName)) {
                    deserializedJobResponseInner.parentJobId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobResponseInner;
        });
    }
}

