/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AccessRights;
import java.io.IOException;

public final class SharedAccessSignatureAuthorizationRuleInner
implements JsonSerializable<SharedAccessSignatureAuthorizationRuleInner> {
    private String keyName;
    private String primaryKey;
    private String secondaryKey;
    private AccessRights rights;
    private static final ClientLogger LOGGER = new ClientLogger(SharedAccessSignatureAuthorizationRuleInner.class);

    public String keyName() {
        return this.keyName;
    }

    public SharedAccessSignatureAuthorizationRuleInner withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String primaryKey() {
        return this.primaryKey;
    }

    public SharedAccessSignatureAuthorizationRuleInner withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public String secondaryKey() {
        return this.secondaryKey;
    }

    public SharedAccessSignatureAuthorizationRuleInner withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    public AccessRights rights() {
        return this.rights;
    }

    public SharedAccessSignatureAuthorizationRuleInner withRights(AccessRights rights) {
        this.rights = rights;
        return this;
    }

    public void validate() {
        if (this.keyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyName in model SharedAccessSignatureAuthorizationRuleInner"));
        }
        if (this.rights() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rights in model SharedAccessSignatureAuthorizationRuleInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("rights", this.rights == null ? null : this.rights.toString());
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        return jsonWriter.writeEndObject();
    }

    public static SharedAccessSignatureAuthorizationRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (SharedAccessSignatureAuthorizationRuleInner)jsonReader.readObject(reader -> {
            SharedAccessSignatureAuthorizationRuleInner deserializedSharedAccessSignatureAuthorizationRuleInner = new SharedAccessSignatureAuthorizationRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedSharedAccessSignatureAuthorizationRuleInner.keyName = reader.getString();
                    continue;
                }
                if ("rights".equals(fieldName)) {
                    deserializedSharedAccessSignatureAuthorizationRuleInner.rights = AccessRights.fromString(reader.getString());
                    continue;
                }
                if ("primaryKey".equals(fieldName)) {
                    deserializedSharedAccessSignatureAuthorizationRuleInner.primaryKey = reader.getString();
                    continue;
                }
                if ("secondaryKey".equals(fieldName)) {
                    deserializedSharedAccessSignatureAuthorizationRuleInner.secondaryKey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedAccessSignatureAuthorizationRuleInner;
        });
    }
}

