/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.ArmUserIdentity;
import com.azure.resourcemanager.iothub.models.ResourceIdentityType;
import java.io.IOException;
import java.util.Map;

public final class ArmIdentity
implements JsonSerializable<ArmIdentity> {
    private String principalId;
    private String tenantId;
    private ResourceIdentityType type;
    private Map<String, ArmUserIdentity> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public ArmIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, ArmUserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ArmIdentity withUserAssignedIdentities(Map<String, ArmUserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ArmIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (ArmIdentity)jsonReader.readObject(reader -> {
            ArmIdentity deserializedArmIdentity = new ArmIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedArmIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedArmIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedArmIdentity.type = ResourceIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedArmIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> ArmUserIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArmIdentity;
        });
    }
}

