/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CertificateProperties
implements JsonSerializable<CertificateProperties> {
    private String subject;
    private DateTimeRfc1123 expiry;
    private String thumbprint;
    private Boolean isVerified;
    private DateTimeRfc1123 created;
    private DateTimeRfc1123 updated;
    private String certificate;

    public String subject() {
        return this.subject;
    }

    public OffsetDateTime expiry() {
        if (this.expiry == null) {
            return null;
        }
        return this.expiry.getDateTime();
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean isVerified() {
        return this.isVerified;
    }

    public CertificateProperties withIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
        return this;
    }

    public OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return this.created.getDateTime();
    }

    public OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return this.updated.getDateTime();
    }

    public String certificate() {
        return this.certificate;
    }

    public CertificateProperties withCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isVerified", this.isVerified);
        jsonWriter.writeStringField("certificate", this.certificate);
        return jsonWriter.writeEndObject();
    }

    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateProperties)jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    deserializedCertificateProperties.subject = reader.getString();
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedCertificateProperties.expiry = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("isVerified".equals(fieldName)) {
                    deserializedCertificateProperties.isVerified = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedCertificateProperties.created = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedCertificateProperties.updated = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    deserializedCertificateProperties.certificate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateProperties;
        });
    }
}

