/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CertificatePropertiesWithNonce
implements JsonSerializable<CertificatePropertiesWithNonce> {
    private String subject;
    private DateTimeRfc1123 expiry;
    private String thumbprint;
    private Boolean isVerified;
    private DateTimeRfc1123 created;
    private DateTimeRfc1123 updated;
    private String verificationCode;
    private String certificate;

    public String subject() {
        return this.subject;
    }

    public OffsetDateTime expiry() {
        if (this.expiry == null) {
            return null;
        }
        return this.expiry.getDateTime();
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean isVerified() {
        return this.isVerified;
    }

    public OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return this.created.getDateTime();
    }

    public OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return this.updated.getDateTime();
    }

    public String verificationCode() {
        return this.verificationCode;
    }

    public String certificate() {
        return this.certificate;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static CertificatePropertiesWithNonce fromJson(JsonReader jsonReader) throws IOException {
        return (CertificatePropertiesWithNonce)jsonReader.readObject(reader -> {
            CertificatePropertiesWithNonce deserializedCertificatePropertiesWithNonce = new CertificatePropertiesWithNonce();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.subject = reader.getString();
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.expiry = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.thumbprint = reader.getString();
                    continue;
                }
                if ("isVerified".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.isVerified = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.created = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.updated = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("verificationCode".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.verificationCode = reader.getString();
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    deserializedCertificatePropertiesWithNonce.certificate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificatePropertiesWithNonce;
        });
    }
}

