/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.FeedbackProperties;
import java.io.IOException;
import java.time.Duration;

public final class CloudToDeviceProperties
implements JsonSerializable<CloudToDeviceProperties> {
    private Integer maxDeliveryCount;
    private Duration defaultTtlAsIso8601;
    private FeedbackProperties feedback;

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public CloudToDeviceProperties withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public Duration defaultTtlAsIso8601() {
        return this.defaultTtlAsIso8601;
    }

    public CloudToDeviceProperties withDefaultTtlAsIso8601(Duration defaultTtlAsIso8601) {
        this.defaultTtlAsIso8601 = defaultTtlAsIso8601;
        return this;
    }

    public FeedbackProperties feedback() {
        return this.feedback;
    }

    public CloudToDeviceProperties withFeedback(FeedbackProperties feedback) {
        this.feedback = feedback;
        return this;
    }

    public void validate() {
        if (this.feedback() != null) {
            this.feedback().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxDeliveryCount", (Number)this.maxDeliveryCount);
        jsonWriter.writeStringField("defaultTtlAsIso8601", CoreUtils.durationToStringWithDays((Duration)this.defaultTtlAsIso8601));
        jsonWriter.writeJsonField("feedback", (JsonSerializable)this.feedback);
        return jsonWriter.writeEndObject();
    }

    public static CloudToDeviceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CloudToDeviceProperties)jsonReader.readObject(reader -> {
            CloudToDeviceProperties deserializedCloudToDeviceProperties = new CloudToDeviceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedCloudToDeviceProperties.maxDeliveryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultTtlAsIso8601".equals(fieldName)) {
                    deserializedCloudToDeviceProperties.defaultTtlAsIso8601 = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("feedback".equals(fieldName)) {
                    deserializedCloudToDeviceProperties.feedback = FeedbackProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudToDeviceProperties;
        });
    }
}

