/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EnrichmentProperties
implements JsonSerializable<EnrichmentProperties> {
    private String key;
    private String value;
    private List<String> endpointNames;
    private static final ClientLogger LOGGER = new ClientLogger(EnrichmentProperties.class);

    public String key() {
        return this.key;
    }

    public EnrichmentProperties withKey(String key) {
        this.key = key;
        return this;
    }

    public String value() {
        return this.value;
    }

    public EnrichmentProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public List<String> endpointNames() {
        return this.endpointNames;
    }

    public EnrichmentProperties withEndpointNames(List<String> endpointNames) {
        this.endpointNames = endpointNames;
        return this;
    }

    public void validate() {
        if (this.key() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property key in model EnrichmentProperties"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model EnrichmentProperties"));
        }
        if (this.endpointNames() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointNames in model EnrichmentProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeArrayField("endpointNames", this.endpointNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static EnrichmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EnrichmentProperties)jsonReader.readObject(reader -> {
            EnrichmentProperties deserializedEnrichmentProperties = new EnrichmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedEnrichmentProperties.key = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedEnrichmentProperties.value = reader.getString();
                    continue;
                }
                if ("endpointNames".equals(fieldName)) {
                    List endpointNames;
                    deserializedEnrichmentProperties.endpointNames = endpointNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEnrichmentProperties;
        });
    }
}

