/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.management.exception.AdditionalInfo;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ErrorDetails
extends ManagementError {
    private String httpStatusCode;
    private List<AdditionalInfo> additionalInfo;
    private List<ManagementError> details;
    private String target;
    private String message;
    private String code;

    public String getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public List<AdditionalInfo> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public List<ManagementError> getDetails() {
        return this.details;
    }

    public String getTarget() {
        return this.target;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ErrorDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorDetails)((Object)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return ErrorDetails.readManagementError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return ErrorDetails.readManagementError(bufferedReader.reset());
        }));
    }

    private static ErrorDetails readManagementError(JsonReader jsonReader) throws IOException {
        return (ErrorDetails)((Object)jsonReader.readObject(reader -> {
            ErrorDetails deserializedErrorDetails = new ErrorDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedErrorDetails.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedErrorDetails.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedErrorDetails.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedErrorDetails.details = details = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedErrorDetails.additionalInfo = additionalInfo = reader.readArray(reader1 -> AdditionalInfo.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("httpStatusCode".equals(fieldName)) {
                    deserializedErrorDetails.httpStatusCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedErrorDetails;
        }));
    }
}

