/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EventHubProperties
implements JsonSerializable<EventHubProperties> {
    private Long retentionTimeInDays;
    private Integer partitionCount;
    private List<String> partitionIds;
    private String path;
    private String endpoint;

    public Long retentionTimeInDays() {
        return this.retentionTimeInDays;
    }

    public EventHubProperties withRetentionTimeInDays(Long retentionTimeInDays) {
        this.retentionTimeInDays = retentionTimeInDays;
        return this;
    }

    public Integer partitionCount() {
        return this.partitionCount;
    }

    public EventHubProperties withPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public List<String> partitionIds() {
        return this.partitionIds;
    }

    public String path() {
        return this.path;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("retentionTimeInDays", (Number)this.retentionTimeInDays);
        jsonWriter.writeNumberField("partitionCount", (Number)this.partitionCount);
        return jsonWriter.writeEndObject();
    }

    public static EventHubProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EventHubProperties)jsonReader.readObject(reader -> {
            EventHubProperties deserializedEventHubProperties = new EventHubProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("retentionTimeInDays".equals(fieldName)) {
                    deserializedEventHubProperties.retentionTimeInDays = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("partitionCount".equals(fieldName)) {
                    deserializedEventHubProperties.partitionCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("partitionIds".equals(fieldName)) {
                    List partitionIds;
                    deserializedEventHubProperties.partitionIds = partitionIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedEventHubProperties.path = reader.getString();
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedEventHubProperties.endpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventHubProperties;
        });
    }
}

