/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import java.io.IOException;

public final class ExportDevicesRequest
implements JsonSerializable<ExportDevicesRequest> {
    private String exportBlobContainerUri;
    private boolean excludeKeys;
    private String exportBlobName;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private Boolean includeConfigurations;
    private String configurationsBlobName;
    private static final ClientLogger LOGGER = new ClientLogger(ExportDevicesRequest.class);

    public String exportBlobContainerUri() {
        return this.exportBlobContainerUri;
    }

    public ExportDevicesRequest withExportBlobContainerUri(String exportBlobContainerUri) {
        this.exportBlobContainerUri = exportBlobContainerUri;
        return this;
    }

    public boolean excludeKeys() {
        return this.excludeKeys;
    }

    public ExportDevicesRequest withExcludeKeys(boolean excludeKeys) {
        this.excludeKeys = excludeKeys;
        return this;
    }

    public String exportBlobName() {
        return this.exportBlobName;
    }

    public ExportDevicesRequest withExportBlobName(String exportBlobName) {
        this.exportBlobName = exportBlobName;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ExportDevicesRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public ExportDevicesRequest withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Boolean includeConfigurations() {
        return this.includeConfigurations;
    }

    public ExportDevicesRequest withIncludeConfigurations(Boolean includeConfigurations) {
        this.includeConfigurations = includeConfigurations;
        return this;
    }

    public String configurationsBlobName() {
        return this.configurationsBlobName;
    }

    public ExportDevicesRequest withConfigurationsBlobName(String configurationsBlobName) {
        this.configurationsBlobName = configurationsBlobName;
        return this;
    }

    public void validate() {
        if (this.exportBlobContainerUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exportBlobContainerUri in model ExportDevicesRequest"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("exportBlobContainerUri", this.exportBlobContainerUri);
        jsonWriter.writeBooleanField("excludeKeys", this.excludeKeys);
        jsonWriter.writeStringField("exportBlobName", this.exportBlobName);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeBooleanField("includeConfigurations", this.includeConfigurations);
        jsonWriter.writeStringField("configurationsBlobName", this.configurationsBlobName);
        return jsonWriter.writeEndObject();
    }

    public static ExportDevicesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ExportDevicesRequest)jsonReader.readObject(reader -> {
            ExportDevicesRequest deserializedExportDevicesRequest = new ExportDevicesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exportBlobContainerUri".equals(fieldName)) {
                    deserializedExportDevicesRequest.exportBlobContainerUri = reader.getString();
                    continue;
                }
                if ("excludeKeys".equals(fieldName)) {
                    deserializedExportDevicesRequest.excludeKeys = reader.getBoolean();
                    continue;
                }
                if ("exportBlobName".equals(fieldName)) {
                    deserializedExportDevicesRequest.exportBlobName = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedExportDevicesRequest.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedExportDevicesRequest.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("includeConfigurations".equals(fieldName)) {
                    deserializedExportDevicesRequest.includeConfigurations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("configurationsBlobName".equals(fieldName)) {
                    deserializedExportDevicesRequest.configurationsBlobName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportDevicesRequest;
        });
    }
}

