/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RoutingSource;
import java.io.IOException;
import java.util.List;

public final class FallbackRouteProperties
implements JsonSerializable<FallbackRouteProperties> {
    private String name;
    private RoutingSource source;
    private String condition;
    private List<String> endpointNames;
    private boolean isEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(FallbackRouteProperties.class);

    public String name() {
        return this.name;
    }

    public FallbackRouteProperties withName(String name) {
        this.name = name;
        return this;
    }

    public RoutingSource source() {
        return this.source;
    }

    public FallbackRouteProperties withSource(RoutingSource source) {
        this.source = source;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public FallbackRouteProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public List<String> endpointNames() {
        return this.endpointNames;
    }

    public FallbackRouteProperties withEndpointNames(List<String> endpointNames) {
        this.endpointNames = endpointNames;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public FallbackRouteProperties withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model FallbackRouteProperties"));
        }
        if (this.endpointNames() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointNames in model FallbackRouteProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeArrayField("endpointNames", this.endpointNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("condition", this.condition);
        return jsonWriter.writeEndObject();
    }

    public static FallbackRouteProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FallbackRouteProperties)jsonReader.readObject(reader -> {
            FallbackRouteProperties deserializedFallbackRouteProperties = new FallbackRouteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedFallbackRouteProperties.source = RoutingSource.fromString(reader.getString());
                    continue;
                }
                if ("endpointNames".equals(fieldName)) {
                    List endpointNames;
                    deserializedFallbackRouteProperties.endpointNames = endpointNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedFallbackRouteProperties.isEnabled = reader.getBoolean();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFallbackRouteProperties.name = reader.getString();
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedFallbackRouteProperties.condition = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFallbackRouteProperties;
        });
    }
}

