/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class FeedbackProperties
implements JsonSerializable<FeedbackProperties> {
    private Duration lockDurationAsIso8601;
    private Duration ttlAsIso8601;
    private Integer maxDeliveryCount;

    public Duration lockDurationAsIso8601() {
        return this.lockDurationAsIso8601;
    }

    public FeedbackProperties withLockDurationAsIso8601(Duration lockDurationAsIso8601) {
        this.lockDurationAsIso8601 = lockDurationAsIso8601;
        return this;
    }

    public Duration ttlAsIso8601() {
        return this.ttlAsIso8601;
    }

    public FeedbackProperties withTtlAsIso8601(Duration ttlAsIso8601) {
        this.ttlAsIso8601 = ttlAsIso8601;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public FeedbackProperties withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lockDurationAsIso8601", CoreUtils.durationToStringWithDays((Duration)this.lockDurationAsIso8601));
        jsonWriter.writeStringField("ttlAsIso8601", CoreUtils.durationToStringWithDays((Duration)this.ttlAsIso8601));
        jsonWriter.writeNumberField("maxDeliveryCount", (Number)this.maxDeliveryCount);
        return jsonWriter.writeEndObject();
    }

    public static FeedbackProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FeedbackProperties)jsonReader.readObject(reader -> {
            FeedbackProperties deserializedFeedbackProperties = new FeedbackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lockDurationAsIso8601".equals(fieldName)) {
                    deserializedFeedbackProperties.lockDurationAsIso8601 = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("ttlAsIso8601".equals(fieldName)) {
                    deserializedFeedbackProperties.ttlAsIso8601 = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedFeedbackProperties.maxDeliveryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFeedbackProperties;
        });
    }
}

