/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import java.io.IOException;

public final class ImportDevicesRequest
implements JsonSerializable<ImportDevicesRequest> {
    private String inputBlobContainerUri;
    private String outputBlobContainerUri;
    private String inputBlobName;
    private String outputBlobName;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private Boolean includeConfigurations;
    private String configurationsBlobName;
    private static final ClientLogger LOGGER = new ClientLogger(ImportDevicesRequest.class);

    public String inputBlobContainerUri() {
        return this.inputBlobContainerUri;
    }

    public ImportDevicesRequest withInputBlobContainerUri(String inputBlobContainerUri) {
        this.inputBlobContainerUri = inputBlobContainerUri;
        return this;
    }

    public String outputBlobContainerUri() {
        return this.outputBlobContainerUri;
    }

    public ImportDevicesRequest withOutputBlobContainerUri(String outputBlobContainerUri) {
        this.outputBlobContainerUri = outputBlobContainerUri;
        return this;
    }

    public String inputBlobName() {
        return this.inputBlobName;
    }

    public ImportDevicesRequest withInputBlobName(String inputBlobName) {
        this.inputBlobName = inputBlobName;
        return this;
    }

    public String outputBlobName() {
        return this.outputBlobName;
    }

    public ImportDevicesRequest withOutputBlobName(String outputBlobName) {
        this.outputBlobName = outputBlobName;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ImportDevicesRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public ImportDevicesRequest withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Boolean includeConfigurations() {
        return this.includeConfigurations;
    }

    public ImportDevicesRequest withIncludeConfigurations(Boolean includeConfigurations) {
        this.includeConfigurations = includeConfigurations;
        return this;
    }

    public String configurationsBlobName() {
        return this.configurationsBlobName;
    }

    public ImportDevicesRequest withConfigurationsBlobName(String configurationsBlobName) {
        this.configurationsBlobName = configurationsBlobName;
        return this;
    }

    public void validate() {
        if (this.inputBlobContainerUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property inputBlobContainerUri in model ImportDevicesRequest"));
        }
        if (this.outputBlobContainerUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property outputBlobContainerUri in model ImportDevicesRequest"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("inputBlobContainerUri", this.inputBlobContainerUri);
        jsonWriter.writeStringField("outputBlobContainerUri", this.outputBlobContainerUri);
        jsonWriter.writeStringField("inputBlobName", this.inputBlobName);
        jsonWriter.writeStringField("outputBlobName", this.outputBlobName);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeBooleanField("includeConfigurations", this.includeConfigurations);
        jsonWriter.writeStringField("configurationsBlobName", this.configurationsBlobName);
        return jsonWriter.writeEndObject();
    }

    public static ImportDevicesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ImportDevicesRequest)jsonReader.readObject(reader -> {
            ImportDevicesRequest deserializedImportDevicesRequest = new ImportDevicesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputBlobContainerUri".equals(fieldName)) {
                    deserializedImportDevicesRequest.inputBlobContainerUri = reader.getString();
                    continue;
                }
                if ("outputBlobContainerUri".equals(fieldName)) {
                    deserializedImportDevicesRequest.outputBlobContainerUri = reader.getString();
                    continue;
                }
                if ("inputBlobName".equals(fieldName)) {
                    deserializedImportDevicesRequest.inputBlobName = reader.getString();
                    continue;
                }
                if ("outputBlobName".equals(fieldName)) {
                    deserializedImportDevicesRequest.outputBlobName = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedImportDevicesRequest.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedImportDevicesRequest.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("includeConfigurations".equals(fieldName)) {
                    deserializedImportDevicesRequest.includeConfigurations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("configurationsBlobName".equals(fieldName)) {
                    deserializedImportDevicesRequest.configurationsBlobName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportDevicesRequest;
        });
    }
}

