/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.IotHubReplicaRoleType;
import java.io.IOException;

public final class IotHubLocationDescription
implements JsonSerializable<IotHubLocationDescription> {
    private String location;
    private IotHubReplicaRoleType role;

    public String location() {
        return this.location;
    }

    public IotHubLocationDescription withLocation(String location) {
        this.location = location;
        return this;
    }

    public IotHubReplicaRoleType role() {
        return this.role;
    }

    public IotHubLocationDescription withRole(IotHubReplicaRoleType role) {
        this.role = role;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static IotHubLocationDescription fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubLocationDescription)jsonReader.readObject(reader -> {
            IotHubLocationDescription deserializedIotHubLocationDescription = new IotHubLocationDescription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedIotHubLocationDescription.location = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedIotHubLocationDescription.role = IotHubReplicaRoleType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubLocationDescription;
        });
    }
}

