/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.iothub.fluent.models.SharedAccessSignatureAuthorizationRuleInner;
import com.azure.resourcemanager.iothub.models.Capabilities;
import com.azure.resourcemanager.iothub.models.CloudToDeviceProperties;
import com.azure.resourcemanager.iothub.models.EventHubProperties;
import com.azure.resourcemanager.iothub.models.IotHubLocationDescription;
import com.azure.resourcemanager.iothub.models.IpFilterRule;
import com.azure.resourcemanager.iothub.models.MessagingEndpointProperties;
import com.azure.resourcemanager.iothub.models.NetworkRuleSetProperties;
import com.azure.resourcemanager.iothub.models.PublicNetworkAccess;
import com.azure.resourcemanager.iothub.models.RoutingProperties;
import com.azure.resourcemanager.iothub.models.StorageEndpointProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class IotHubProperties
implements JsonSerializable<IotHubProperties> {
    private List<SharedAccessSignatureAuthorizationRuleInner> authorizationPolicies;
    private Boolean disableLocalAuth;
    private Boolean disableDeviceSas;
    private Boolean disableModuleSas;
    private Boolean restrictOutboundNetworkAccess;
    private List<String> allowedFqdnList;
    private PublicNetworkAccess publicNetworkAccess;
    private List<IpFilterRule> ipFilterRules;
    private NetworkRuleSetProperties networkRuleSets;
    private String minTlsVersion;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private String provisioningState;
    private String state;
    private String hostname;
    private Map<String, EventHubProperties> eventHubEndpoints;
    private RoutingProperties routing;
    private Map<String, StorageEndpointProperties> storageEndpoints;
    private Map<String, MessagingEndpointProperties> messagingEndpoints;
    private Boolean enableFileUploadNotifications;
    private CloudToDeviceProperties cloudToDevice;
    private String comments;
    private Capabilities features;
    private List<IotHubLocationDescription> locations;
    private Boolean enableDataResidency;

    public List<SharedAccessSignatureAuthorizationRuleInner> authorizationPolicies() {
        return this.authorizationPolicies;
    }

    public IotHubProperties withAuthorizationPolicies(List<SharedAccessSignatureAuthorizationRuleInner> authorizationPolicies) {
        this.authorizationPolicies = authorizationPolicies;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public IotHubProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean disableDeviceSas() {
        return this.disableDeviceSas;
    }

    public IotHubProperties withDisableDeviceSas(Boolean disableDeviceSas) {
        this.disableDeviceSas = disableDeviceSas;
        return this;
    }

    public Boolean disableModuleSas() {
        return this.disableModuleSas;
    }

    public IotHubProperties withDisableModuleSas(Boolean disableModuleSas) {
        this.disableModuleSas = disableModuleSas;
        return this;
    }

    public Boolean restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    public IotHubProperties withRestrictOutboundNetworkAccess(Boolean restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    public List<String> allowedFqdnList() {
        return this.allowedFqdnList;
    }

    public IotHubProperties withAllowedFqdnList(List<String> allowedFqdnList) {
        this.allowedFqdnList = allowedFqdnList;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public IotHubProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<IpFilterRule> ipFilterRules() {
        return this.ipFilterRules;
    }

    public IotHubProperties withIpFilterRules(List<IpFilterRule> ipFilterRules) {
        this.ipFilterRules = ipFilterRules;
        return this;
    }

    public NetworkRuleSetProperties networkRuleSets() {
        return this.networkRuleSets;
    }

    public IotHubProperties withNetworkRuleSets(NetworkRuleSetProperties networkRuleSets) {
        this.networkRuleSets = networkRuleSets;
        return this;
    }

    public String minTlsVersion() {
        return this.minTlsVersion;
    }

    public IotHubProperties withMinTlsVersion(String minTlsVersion) {
        this.minTlsVersion = minTlsVersion;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public IotHubProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String state() {
        return this.state;
    }

    public String hostname() {
        return this.hostname;
    }

    public Map<String, EventHubProperties> eventHubEndpoints() {
        return this.eventHubEndpoints;
    }

    public IotHubProperties withEventHubEndpoints(Map<String, EventHubProperties> eventHubEndpoints) {
        this.eventHubEndpoints = eventHubEndpoints;
        return this;
    }

    public RoutingProperties routing() {
        return this.routing;
    }

    public IotHubProperties withRouting(RoutingProperties routing) {
        this.routing = routing;
        return this;
    }

    public Map<String, StorageEndpointProperties> storageEndpoints() {
        return this.storageEndpoints;
    }

    public IotHubProperties withStorageEndpoints(Map<String, StorageEndpointProperties> storageEndpoints) {
        this.storageEndpoints = storageEndpoints;
        return this;
    }

    public Map<String, MessagingEndpointProperties> messagingEndpoints() {
        return this.messagingEndpoints;
    }

    public IotHubProperties withMessagingEndpoints(Map<String, MessagingEndpointProperties> messagingEndpoints) {
        this.messagingEndpoints = messagingEndpoints;
        return this;
    }

    public Boolean enableFileUploadNotifications() {
        return this.enableFileUploadNotifications;
    }

    public IotHubProperties withEnableFileUploadNotifications(Boolean enableFileUploadNotifications) {
        this.enableFileUploadNotifications = enableFileUploadNotifications;
        return this;
    }

    public CloudToDeviceProperties cloudToDevice() {
        return this.cloudToDevice;
    }

    public IotHubProperties withCloudToDevice(CloudToDeviceProperties cloudToDevice) {
        this.cloudToDevice = cloudToDevice;
        return this;
    }

    public String comments() {
        return this.comments;
    }

    public IotHubProperties withComments(String comments) {
        this.comments = comments;
        return this;
    }

    public Capabilities features() {
        return this.features;
    }

    public IotHubProperties withFeatures(Capabilities features) {
        this.features = features;
        return this;
    }

    public List<IotHubLocationDescription> locations() {
        return this.locations;
    }

    public Boolean enableDataResidency() {
        return this.enableDataResidency;
    }

    public IotHubProperties withEnableDataResidency(Boolean enableDataResidency) {
        this.enableDataResidency = enableDataResidency;
        return this;
    }

    public void validate() {
        if (this.authorizationPolicies() != null) {
            this.authorizationPolicies().forEach(e -> e.validate());
        }
        if (this.ipFilterRules() != null) {
            this.ipFilterRules().forEach(e -> e.validate());
        }
        if (this.networkRuleSets() != null) {
            this.networkRuleSets().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.eventHubEndpoints() != null) {
            this.eventHubEndpoints().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.routing() != null) {
            this.routing().validate();
        }
        if (this.storageEndpoints() != null) {
            this.storageEndpoints().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.messagingEndpoints() != null) {
            this.messagingEndpoints().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.cloudToDevice() != null) {
            this.cloudToDevice().validate();
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("authorizationPolicies", this.authorizationPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeBooleanField("disableDeviceSAS", this.disableDeviceSas);
        jsonWriter.writeBooleanField("disableModuleSAS", this.disableModuleSas);
        jsonWriter.writeBooleanField("restrictOutboundNetworkAccess", this.restrictOutboundNetworkAccess);
        jsonWriter.writeArrayField("allowedFqdnList", this.allowedFqdnList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("ipFilterRules", this.ipFilterRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("networkRuleSets", (JsonSerializable)this.networkRuleSets);
        jsonWriter.writeStringField("minTlsVersion", this.minTlsVersion);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("eventHubEndpoints", this.eventHubEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("routing", (JsonSerializable)this.routing);
        jsonWriter.writeMapField("storageEndpoints", this.storageEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("messagingEndpoints", this.messagingEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableFileUploadNotifications", this.enableFileUploadNotifications);
        jsonWriter.writeJsonField("cloudToDevice", (JsonSerializable)this.cloudToDevice);
        jsonWriter.writeStringField("comments", this.comments);
        jsonWriter.writeStringField("features", this.features == null ? null : this.features.toString());
        jsonWriter.writeBooleanField("enableDataResidency", this.enableDataResidency);
        return jsonWriter.writeEndObject();
    }

    public static IotHubProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubProperties)jsonReader.readObject(reader -> {
            IotHubProperties deserializedIotHubProperties = new IotHubProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authorizationPolicies".equals(fieldName)) {
                    List authorizationPolicies;
                    deserializedIotHubProperties.authorizationPolicies = authorizationPolicies = reader.readArray(reader1 -> SharedAccessSignatureAuthorizationRuleInner.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedIotHubProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableDeviceSAS".equals(fieldName)) {
                    deserializedIotHubProperties.disableDeviceSas = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableModuleSAS".equals(fieldName)) {
                    deserializedIotHubProperties.disableModuleSas = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("restrictOutboundNetworkAccess".equals(fieldName)) {
                    deserializedIotHubProperties.restrictOutboundNetworkAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowedFqdnList".equals(fieldName)) {
                    List allowedFqdnList;
                    deserializedIotHubProperties.allowedFqdnList = allowedFqdnList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedIotHubProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("ipFilterRules".equals(fieldName)) {
                    List ipFilterRules;
                    deserializedIotHubProperties.ipFilterRules = ipFilterRules = reader.readArray(reader1 -> IpFilterRule.fromJson(reader1));
                    continue;
                }
                if ("networkRuleSets".equals(fieldName)) {
                    deserializedIotHubProperties.networkRuleSets = NetworkRuleSetProperties.fromJson(reader);
                    continue;
                }
                if ("minTlsVersion".equals(fieldName)) {
                    deserializedIotHubProperties.minTlsVersion = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedIotHubProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedIotHubProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIotHubProperties.state = reader.getString();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedIotHubProperties.hostname = reader.getString();
                    continue;
                }
                if ("eventHubEndpoints".equals(fieldName)) {
                    Map eventHubEndpoints;
                    deserializedIotHubProperties.eventHubEndpoints = eventHubEndpoints = reader.readMap(reader1 -> EventHubProperties.fromJson(reader1));
                    continue;
                }
                if ("routing".equals(fieldName)) {
                    deserializedIotHubProperties.routing = RoutingProperties.fromJson(reader);
                    continue;
                }
                if ("storageEndpoints".equals(fieldName)) {
                    Map storageEndpoints;
                    deserializedIotHubProperties.storageEndpoints = storageEndpoints = reader.readMap(reader1 -> StorageEndpointProperties.fromJson(reader1));
                    continue;
                }
                if ("messagingEndpoints".equals(fieldName)) {
                    Map messagingEndpoints;
                    deserializedIotHubProperties.messagingEndpoints = messagingEndpoints = reader.readMap(reader1 -> MessagingEndpointProperties.fromJson(reader1));
                    continue;
                }
                if ("enableFileUploadNotifications".equals(fieldName)) {
                    deserializedIotHubProperties.enableFileUploadNotifications = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cloudToDevice".equals(fieldName)) {
                    deserializedIotHubProperties.cloudToDevice = CloudToDeviceProperties.fromJson(reader);
                    continue;
                }
                if ("comments".equals(fieldName)) {
                    deserializedIotHubProperties.comments = reader.getString();
                    continue;
                }
                if ("features".equals(fieldName)) {
                    deserializedIotHubProperties.features = Capabilities.fromString(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedIotHubProperties.locations = locations = reader.readArray(reader1 -> IotHubLocationDescription.fromJson(reader1));
                    continue;
                }
                if ("enableDataResidency".equals(fieldName)) {
                    deserializedIotHubProperties.enableDataResidency = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubProperties;
        });
    }
}

