/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.IotHubSku;
import com.azure.resourcemanager.iothub.models.IotHubSkuTier;
import java.io.IOException;

public final class IotHubSkuInfo
implements JsonSerializable<IotHubSkuInfo> {
    private IotHubSku name;
    private IotHubSkuTier tier;
    private Long capacity;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubSkuInfo.class);

    public IotHubSku name() {
        return this.name;
    }

    public IotHubSkuInfo withName(IotHubSku name) {
        this.name = name;
        return this;
    }

    public IotHubSkuTier tier() {
        return this.tier;
    }

    public Long capacity() {
        return this.capacity;
    }

    public IotHubSkuInfo withCapacity(Long capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model IotHubSkuInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static IotHubSkuInfo fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubSkuInfo)jsonReader.readObject(reader -> {
            IotHubSkuInfo deserializedIotHubSkuInfo = new IotHubSkuInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIotHubSkuInfo.name = IotHubSku.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedIotHubSkuInfo.tier = IotHubSkuTier.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedIotHubSkuInfo.capacity = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubSkuInfo;
        });
    }
}

