/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.IpFilterActionType;
import java.io.IOException;

public final class IpFilterRule
implements JsonSerializable<IpFilterRule> {
    private String filterName;
    private IpFilterActionType action;
    private String ipMask;
    private static final ClientLogger LOGGER = new ClientLogger(IpFilterRule.class);

    public String filterName() {
        return this.filterName;
    }

    public IpFilterRule withFilterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public IpFilterActionType action() {
        return this.action;
    }

    public IpFilterRule withAction(IpFilterActionType action) {
        this.action = action;
        return this;
    }

    public String ipMask() {
        return this.ipMask;
    }

    public IpFilterRule withIpMask(String ipMask) {
        this.ipMask = ipMask;
        return this;
    }

    public void validate() {
        if (this.filterName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filterName in model IpFilterRule"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model IpFilterRule"));
        }
        if (this.ipMask() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipMask in model IpFilterRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterName", this.filterName);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("ipMask", this.ipMask);
        return jsonWriter.writeEndObject();
    }

    public static IpFilterRule fromJson(JsonReader jsonReader) throws IOException {
        return (IpFilterRule)jsonReader.readObject(reader -> {
            IpFilterRule deserializedIpFilterRule = new IpFilterRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filterName".equals(fieldName)) {
                    deserializedIpFilterRule.filterName = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedIpFilterRule.action = IpFilterActionType.fromString(reader.getString());
                    continue;
                }
                if ("ipMask".equals(fieldName)) {
                    deserializedIpFilterRule.ipMask = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpFilterRule;
        });
    }
}

