/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public final class MessagingEndpointProperties
implements JsonSerializable<MessagingEndpointProperties> {
    private Duration lockDurationAsIso8601;
    private Duration ttlAsIso8601;
    private Integer maxDeliveryCount;

    public Duration lockDurationAsIso8601() {
        return this.lockDurationAsIso8601;
    }

    public MessagingEndpointProperties withLockDurationAsIso8601(Duration lockDurationAsIso8601) {
        this.lockDurationAsIso8601 = lockDurationAsIso8601;
        return this;
    }

    public Duration ttlAsIso8601() {
        return this.ttlAsIso8601;
    }

    public MessagingEndpointProperties withTtlAsIso8601(Duration ttlAsIso8601) {
        this.ttlAsIso8601 = ttlAsIso8601;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public MessagingEndpointProperties withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lockDurationAsIso8601", CoreUtils.durationToStringWithDays((Duration)this.lockDurationAsIso8601));
        jsonWriter.writeStringField("ttlAsIso8601", CoreUtils.durationToStringWithDays((Duration)this.ttlAsIso8601));
        jsonWriter.writeNumberField("maxDeliveryCount", (Number)this.maxDeliveryCount);
        return jsonWriter.writeEndObject();
    }

    public static MessagingEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MessagingEndpointProperties)jsonReader.readObject(reader -> {
            MessagingEndpointProperties deserializedMessagingEndpointProperties = new MessagingEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lockDurationAsIso8601".equals(fieldName)) {
                    deserializedMessagingEndpointProperties.lockDurationAsIso8601 = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("ttlAsIso8601".equals(fieldName)) {
                    deserializedMessagingEndpointProperties.ttlAsIso8601 = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedMessagingEndpointProperties.maxDeliveryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMessagingEndpointProperties;
        });
    }
}

