/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.NetworkRuleIpAction;
import java.io.IOException;

public final class NetworkRuleSetIpRule
implements JsonSerializable<NetworkRuleSetIpRule> {
    private String filterName;
    private NetworkRuleIpAction action;
    private String ipMask;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkRuleSetIpRule.class);

    public String filterName() {
        return this.filterName;
    }

    public NetworkRuleSetIpRule withFilterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public NetworkRuleIpAction action() {
        return this.action;
    }

    public NetworkRuleSetIpRule withAction(NetworkRuleIpAction action) {
        this.action = action;
        return this;
    }

    public String ipMask() {
        return this.ipMask;
    }

    public NetworkRuleSetIpRule withIpMask(String ipMask) {
        this.ipMask = ipMask;
        return this;
    }

    public void validate() {
        if (this.filterName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filterName in model NetworkRuleSetIpRule"));
        }
        if (this.ipMask() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipMask in model NetworkRuleSetIpRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterName", this.filterName);
        jsonWriter.writeStringField("ipMask", this.ipMask);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSetIpRule fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkRuleSetIpRule)jsonReader.readObject(reader -> {
            NetworkRuleSetIpRule deserializedNetworkRuleSetIpRule = new NetworkRuleSetIpRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filterName".equals(fieldName)) {
                    deserializedNetworkRuleSetIpRule.filterName = reader.getString();
                    continue;
                }
                if ("ipMask".equals(fieldName)) {
                    deserializedNetworkRuleSetIpRule.ipMask = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedNetworkRuleSetIpRule.action = NetworkRuleIpAction.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSetIpRule;
        });
    }
}

