/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.DefaultAction;
import com.azure.resourcemanager.iothub.models.NetworkRuleSetIpRule;
import java.io.IOException;
import java.util.List;

public final class NetworkRuleSetProperties
implements JsonSerializable<NetworkRuleSetProperties> {
    private DefaultAction defaultAction;
    private boolean applyToBuiltInEventHubEndpoint;
    private List<NetworkRuleSetIpRule> ipRules;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkRuleSetProperties.class);

    public DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSetProperties withDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public boolean applyToBuiltInEventHubEndpoint() {
        return this.applyToBuiltInEventHubEndpoint;
    }

    public NetworkRuleSetProperties withApplyToBuiltInEventHubEndpoint(boolean applyToBuiltInEventHubEndpoint) {
        this.applyToBuiltInEventHubEndpoint = applyToBuiltInEventHubEndpoint;
        return this;
    }

    public List<NetworkRuleSetIpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSetProperties withIpRules(List<NetworkRuleSetIpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public void validate() {
        if (this.ipRules() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipRules in model NetworkRuleSetProperties"));
        }
        this.ipRules().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("applyToBuiltInEventHubEndpoint", this.applyToBuiltInEventHubEndpoint);
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkRuleSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkRuleSetProperties)jsonReader.readObject(reader -> {
            NetworkRuleSetProperties deserializedNetworkRuleSetProperties = new NetworkRuleSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("applyToBuiltInEventHubEndpoint".equals(fieldName)) {
                    deserializedNetworkRuleSetProperties.applyToBuiltInEventHubEndpoint = reader.getBoolean();
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedNetworkRuleSetProperties.ipRules = ipRules = reader.readArray(reader1 -> NetworkRuleSetIpRule.fromJson(reader1));
                    continue;
                }
                if ("defaultAction".equals(fieldName)) {
                    deserializedNetworkRuleSetProperties.defaultAction = DefaultAction.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRuleSetProperties;
        });
    }
}

