/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.PrivateEndpoint;
import com.azure.resourcemanager.iothub.models.PrivateLinkServiceConnectionState;
import java.io.IOException;

public final class PrivateEndpointConnectionProperties
implements JsonSerializable<PrivateEndpointConnectionProperties> {
    private PrivateEndpoint privateEndpoint;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionProperties.class);

    public PrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnectionProperties withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privateLinkServiceConnectionState in model PrivateEndpointConnectionProperties"));
        }
        this.privateLinkServiceConnectionState().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionProperties)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionProperties deserializedPrivateEndpointConnectionProperties = new PrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionProperties.privateEndpoint = PrivateEndpoint.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionProperties;
        });
    }
}

