/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RouteErrorRange;
import com.azure.resourcemanager.iothub.models.RouteErrorSeverity;
import java.io.IOException;

public final class RouteCompilationError
implements JsonSerializable<RouteCompilationError> {
    private String message;
    private RouteErrorSeverity severity;
    private RouteErrorRange location;

    public String message() {
        return this.message;
    }

    public RouteCompilationError withMessage(String message) {
        this.message = message;
        return this;
    }

    public RouteErrorSeverity severity() {
        return this.severity;
    }

    public RouteCompilationError withSeverity(RouteErrorSeverity severity) {
        this.severity = severity;
        return this;
    }

    public RouteErrorRange location() {
        return this.location;
    }

    public RouteCompilationError withLocation(RouteErrorRange location) {
        this.location = location;
        return this;
    }

    public void validate() {
        if (this.location() != null) {
            this.location().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        return jsonWriter.writeEndObject();
    }

    public static RouteCompilationError fromJson(JsonReader jsonReader) throws IOException {
        return (RouteCompilationError)jsonReader.readObject(reader -> {
            RouteCompilationError deserializedRouteCompilationError = new RouteCompilationError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    deserializedRouteCompilationError.message = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedRouteCompilationError.severity = RouteErrorSeverity.fromString(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRouteCompilationError.location = RouteErrorRange.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteCompilationError;
        });
    }
}

