/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RouteErrorPosition;
import java.io.IOException;

public final class RouteErrorRange
implements JsonSerializable<RouteErrorRange> {
    private RouteErrorPosition start;
    private RouteErrorPosition end;

    public RouteErrorPosition start() {
        return this.start;
    }

    public RouteErrorRange withStart(RouteErrorPosition start) {
        this.start = start;
        return this;
    }

    public RouteErrorPosition end() {
        return this.end;
    }

    public RouteErrorRange withEnd(RouteErrorPosition end) {
        this.end = end;
        return this;
    }

    public void validate() {
        if (this.start() != null) {
            this.start().validate();
        }
        if (this.end() != null) {
            this.end().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("start", (JsonSerializable)this.start);
        jsonWriter.writeJsonField("end", (JsonSerializable)this.end);
        return jsonWriter.writeEndObject();
    }

    public static RouteErrorRange fromJson(JsonReader jsonReader) throws IOException {
        return (RouteErrorRange)jsonReader.readObject(reader -> {
            RouteErrorRange deserializedRouteErrorRange = new RouteErrorRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    deserializedRouteErrorRange.start = RouteErrorPosition.fromJson(reader);
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedRouteErrorRange.end = RouteErrorPosition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteErrorRange;
        });
    }
}

