/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RoutingSource;
import java.io.IOException;
import java.util.List;

public final class RouteProperties
implements JsonSerializable<RouteProperties> {
    private String name;
    private RoutingSource source;
    private String condition;
    private List<String> endpointNames;
    private boolean isEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(RouteProperties.class);

    public String name() {
        return this.name;
    }

    public RouteProperties withName(String name) {
        this.name = name;
        return this;
    }

    public RoutingSource source() {
        return this.source;
    }

    public RouteProperties withSource(RoutingSource source) {
        this.source = source;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RouteProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public List<String> endpointNames() {
        return this.endpointNames;
    }

    public RouteProperties withEndpointNames(List<String> endpointNames) {
        this.endpointNames = endpointNames;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public RouteProperties withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RouteProperties"));
        }
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model RouteProperties"));
        }
        if (this.endpointNames() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpointNames in model RouteProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeArrayField("endpointNames", this.endpointNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("condition", this.condition);
        return jsonWriter.writeEndObject();
    }

    public static RouteProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RouteProperties)jsonReader.readObject(reader -> {
            RouteProperties deserializedRouteProperties = new RouteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRouteProperties.name = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedRouteProperties.source = RoutingSource.fromString(reader.getString());
                    continue;
                }
                if ("endpointNames".equals(fieldName)) {
                    List endpointNames;
                    deserializedRouteProperties.endpointNames = endpointNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedRouteProperties.isEnabled = reader.getBoolean();
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedRouteProperties.condition = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteProperties;
        });
    }
}

