/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RoutingCosmosDBSqlApiProperties;
import com.azure.resourcemanager.iothub.models.RoutingEventHubProperties;
import com.azure.resourcemanager.iothub.models.RoutingServiceBusQueueEndpointProperties;
import com.azure.resourcemanager.iothub.models.RoutingServiceBusTopicEndpointProperties;
import com.azure.resourcemanager.iothub.models.RoutingStorageContainerProperties;
import java.io.IOException;
import java.util.List;

public final class RoutingEndpoints
implements JsonSerializable<RoutingEndpoints> {
    private List<RoutingServiceBusQueueEndpointProperties> serviceBusQueues;
    private List<RoutingServiceBusTopicEndpointProperties> serviceBusTopics;
    private List<RoutingEventHubProperties> eventHubs;
    private List<RoutingStorageContainerProperties> storageContainers;
    private List<RoutingCosmosDBSqlApiProperties> cosmosDBSqlContainers;

    public List<RoutingServiceBusQueueEndpointProperties> serviceBusQueues() {
        return this.serviceBusQueues;
    }

    public RoutingEndpoints withServiceBusQueues(List<RoutingServiceBusQueueEndpointProperties> serviceBusQueues) {
        this.serviceBusQueues = serviceBusQueues;
        return this;
    }

    public List<RoutingServiceBusTopicEndpointProperties> serviceBusTopics() {
        return this.serviceBusTopics;
    }

    public RoutingEndpoints withServiceBusTopics(List<RoutingServiceBusTopicEndpointProperties> serviceBusTopics) {
        this.serviceBusTopics = serviceBusTopics;
        return this;
    }

    public List<RoutingEventHubProperties> eventHubs() {
        return this.eventHubs;
    }

    public RoutingEndpoints withEventHubs(List<RoutingEventHubProperties> eventHubs) {
        this.eventHubs = eventHubs;
        return this;
    }

    public List<RoutingStorageContainerProperties> storageContainers() {
        return this.storageContainers;
    }

    public RoutingEndpoints withStorageContainers(List<RoutingStorageContainerProperties> storageContainers) {
        this.storageContainers = storageContainers;
        return this;
    }

    public List<RoutingCosmosDBSqlApiProperties> cosmosDBSqlContainers() {
        return this.cosmosDBSqlContainers;
    }

    public RoutingEndpoints withCosmosDBSqlContainers(List<RoutingCosmosDBSqlApiProperties> cosmosDBSqlContainers) {
        this.cosmosDBSqlContainers = cosmosDBSqlContainers;
        return this;
    }

    public void validate() {
        if (this.serviceBusQueues() != null) {
            this.serviceBusQueues().forEach(e -> e.validate());
        }
        if (this.serviceBusTopics() != null) {
            this.serviceBusTopics().forEach(e -> e.validate());
        }
        if (this.eventHubs() != null) {
            this.eventHubs().forEach(e -> e.validate());
        }
        if (this.storageContainers() != null) {
            this.storageContainers().forEach(e -> e.validate());
        }
        if (this.cosmosDBSqlContainers() != null) {
            this.cosmosDBSqlContainers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("serviceBusQueues", this.serviceBusQueues, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("serviceBusTopics", this.serviceBusTopics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("eventHubs", this.eventHubs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("storageContainers", this.storageContainers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("cosmosDBSqlContainers", this.cosmosDBSqlContainers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RoutingEndpoints fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingEndpoints)jsonReader.readObject(reader -> {
            RoutingEndpoints deserializedRoutingEndpoints = new RoutingEndpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceBusQueues".equals(fieldName)) {
                    List serviceBusQueues;
                    deserializedRoutingEndpoints.serviceBusQueues = serviceBusQueues = reader.readArray(reader1 -> RoutingServiceBusQueueEndpointProperties.fromJson(reader1));
                    continue;
                }
                if ("serviceBusTopics".equals(fieldName)) {
                    List serviceBusTopics;
                    deserializedRoutingEndpoints.serviceBusTopics = serviceBusTopics = reader.readArray(reader1 -> RoutingServiceBusTopicEndpointProperties.fromJson(reader1));
                    continue;
                }
                if ("eventHubs".equals(fieldName)) {
                    List eventHubs;
                    deserializedRoutingEndpoints.eventHubs = eventHubs = reader.readArray(reader1 -> RoutingEventHubProperties.fromJson(reader1));
                    continue;
                }
                if ("storageContainers".equals(fieldName)) {
                    List storageContainers;
                    deserializedRoutingEndpoints.storageContainers = storageContainers = reader.readArray(reader1 -> RoutingStorageContainerProperties.fromJson(reader1));
                    continue;
                }
                if ("cosmosDBSqlContainers".equals(fieldName)) {
                    List cosmosDBSqlContainers;
                    deserializedRoutingEndpoints.cosmosDBSqlContainers = cosmosDBSqlContainers = reader.readArray(reader1 -> RoutingCosmosDBSqlApiProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingEndpoints;
        });
    }
}

