/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import java.io.IOException;

public final class RoutingEventHubProperties
implements JsonSerializable<RoutingEventHubProperties> {
    private String id;
    private String connectionString;
    private String endpointUri;
    private String entityPath;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private String name;
    private String subscriptionId;
    private String resourceGroup;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingEventHubProperties.class);

    public String id() {
        return this.id;
    }

    public RoutingEventHubProperties withId(String id) {
        this.id = id;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public RoutingEventHubProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public RoutingEventHubProperties withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public String entityPath() {
        return this.entityPath;
    }

    public RoutingEventHubProperties withEntityPath(String entityPath) {
        this.entityPath = entityPath;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public RoutingEventHubProperties withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public RoutingEventHubProperties withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String name() {
        return this.name;
    }

    public RoutingEventHubProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public RoutingEventHubProperties withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public RoutingEventHubProperties withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RoutingEventHubProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeStringField("entityPath", this.entityPath);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        return jsonWriter.writeEndObject();
    }

    public static RoutingEventHubProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingEventHubProperties)jsonReader.readObject(reader -> {
            RoutingEventHubProperties deserializedRoutingEventHubProperties = new RoutingEventHubProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.id = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.connectionString = reader.getString();
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.endpointUri = reader.getString();
                    continue;
                }
                if ("entityPath".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.entityPath = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedRoutingEventHubProperties.resourceGroup = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingEventHubProperties;
        });
    }
}

