/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RoutingMessage
implements JsonSerializable<RoutingMessage> {
    private String body;
    private Map<String, String> appProperties;
    private Map<String, String> systemProperties;

    public String body() {
        return this.body;
    }

    public RoutingMessage withBody(String body) {
        this.body = body;
        return this;
    }

    public Map<String, String> appProperties() {
        return this.appProperties;
    }

    public RoutingMessage withAppProperties(Map<String, String> appProperties) {
        this.appProperties = appProperties;
        return this;
    }

    public Map<String, String> systemProperties() {
        return this.systemProperties;
    }

    public RoutingMessage withSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeMapField("appProperties", this.appProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("systemProperties", this.systemProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RoutingMessage fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingMessage)jsonReader.readObject(reader -> {
            RoutingMessage deserializedRoutingMessage = new RoutingMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("body".equals(fieldName)) {
                    deserializedRoutingMessage.body = reader.getString();
                    continue;
                }
                if ("appProperties".equals(fieldName)) {
                    Map appProperties;
                    deserializedRoutingMessage.appProperties = appProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemProperties".equals(fieldName)) {
                    Map systemProperties;
                    deserializedRoutingMessage.systemProperties = systemProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingMessage;
        });
    }
}

