/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.EnrichmentProperties;
import com.azure.resourcemanager.iothub.models.FallbackRouteProperties;
import com.azure.resourcemanager.iothub.models.RouteProperties;
import com.azure.resourcemanager.iothub.models.RoutingEndpoints;
import java.io.IOException;
import java.util.List;

public final class RoutingProperties
implements JsonSerializable<RoutingProperties> {
    private RoutingEndpoints endpoints;
    private List<RouteProperties> routes;
    private FallbackRouteProperties fallbackRoute;
    private List<EnrichmentProperties> enrichments;

    public RoutingEndpoints endpoints() {
        return this.endpoints;
    }

    public RoutingProperties withEndpoints(RoutingEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<RouteProperties> routes() {
        return this.routes;
    }

    public RoutingProperties withRoutes(List<RouteProperties> routes) {
        this.routes = routes;
        return this;
    }

    public FallbackRouteProperties fallbackRoute() {
        return this.fallbackRoute;
    }

    public RoutingProperties withFallbackRoute(FallbackRouteProperties fallbackRoute) {
        this.fallbackRoute = fallbackRoute;
        return this;
    }

    public List<EnrichmentProperties> enrichments() {
        return this.enrichments;
    }

    public RoutingProperties withEnrichments(List<EnrichmentProperties> enrichments) {
        this.enrichments = enrichments;
        return this;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().validate();
        }
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
        if (this.fallbackRoute() != null) {
            this.fallbackRoute().validate();
        }
        if (this.enrichments() != null) {
            this.enrichments().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("endpoints", (JsonSerializable)this.endpoints);
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("fallbackRoute", (JsonSerializable)this.fallbackRoute);
        jsonWriter.writeArrayField("enrichments", this.enrichments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RoutingProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingProperties)jsonReader.readObject(reader -> {
            RoutingProperties deserializedRoutingProperties = new RoutingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoints".equals(fieldName)) {
                    deserializedRoutingProperties.endpoints = RoutingEndpoints.fromJson(reader);
                    continue;
                }
                if ("routes".equals(fieldName)) {
                    List routes;
                    deserializedRoutingProperties.routes = routes = reader.readArray(reader1 -> RouteProperties.fromJson(reader1));
                    continue;
                }
                if ("fallbackRoute".equals(fieldName)) {
                    deserializedRoutingProperties.fallbackRoute = FallbackRouteProperties.fromJson(reader);
                    continue;
                }
                if ("enrichments".equals(fieldName)) {
                    List enrichments;
                    deserializedRoutingProperties.enrichments = enrichments = reader.readArray(reader1 -> EnrichmentProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingProperties;
        });
    }
}

