/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import java.io.IOException;

public final class RoutingServiceBusQueueEndpointProperties
implements JsonSerializable<RoutingServiceBusQueueEndpointProperties> {
    private String id;
    private String connectionString;
    private String endpointUri;
    private String entityPath;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private String name;
    private String subscriptionId;
    private String resourceGroup;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingServiceBusQueueEndpointProperties.class);

    public String id() {
        return this.id;
    }

    public RoutingServiceBusQueueEndpointProperties withId(String id) {
        this.id = id;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public RoutingServiceBusQueueEndpointProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public RoutingServiceBusQueueEndpointProperties withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public String entityPath() {
        return this.entityPath;
    }

    public RoutingServiceBusQueueEndpointProperties withEntityPath(String entityPath) {
        this.entityPath = entityPath;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public RoutingServiceBusQueueEndpointProperties withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public RoutingServiceBusQueueEndpointProperties withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String name() {
        return this.name;
    }

    public RoutingServiceBusQueueEndpointProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public RoutingServiceBusQueueEndpointProperties withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public RoutingServiceBusQueueEndpointProperties withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RoutingServiceBusQueueEndpointProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeStringField("entityPath", this.entityPath);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        return jsonWriter.writeEndObject();
    }

    public static RoutingServiceBusQueueEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingServiceBusQueueEndpointProperties)jsonReader.readObject(reader -> {
            RoutingServiceBusQueueEndpointProperties deserializedRoutingServiceBusQueueEndpointProperties = new RoutingServiceBusQueueEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.id = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.connectionString = reader.getString();
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.endpointUri = reader.getString();
                    continue;
                }
                if ("entityPath".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.entityPath = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedRoutingServiceBusQueueEndpointProperties.resourceGroup = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingServiceBusQueueEndpointProperties;
        });
    }
}

