/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import java.io.IOException;

public final class RoutingServiceBusTopicEndpointProperties
implements JsonSerializable<RoutingServiceBusTopicEndpointProperties> {
    private String id;
    private String connectionString;
    private String endpointUri;
    private String entityPath;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private String name;
    private String subscriptionId;
    private String resourceGroup;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingServiceBusTopicEndpointProperties.class);

    public String id() {
        return this.id;
    }

    public RoutingServiceBusTopicEndpointProperties withId(String id) {
        this.id = id;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public RoutingServiceBusTopicEndpointProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public RoutingServiceBusTopicEndpointProperties withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public String entityPath() {
        return this.entityPath;
    }

    public RoutingServiceBusTopicEndpointProperties withEntityPath(String entityPath) {
        this.entityPath = entityPath;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public RoutingServiceBusTopicEndpointProperties withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public RoutingServiceBusTopicEndpointProperties withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String name() {
        return this.name;
    }

    public RoutingServiceBusTopicEndpointProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public RoutingServiceBusTopicEndpointProperties withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public RoutingServiceBusTopicEndpointProperties withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RoutingServiceBusTopicEndpointProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeStringField("entityPath", this.entityPath);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        return jsonWriter.writeEndObject();
    }

    public static RoutingServiceBusTopicEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingServiceBusTopicEndpointProperties)jsonReader.readObject(reader -> {
            RoutingServiceBusTopicEndpointProperties deserializedRoutingServiceBusTopicEndpointProperties = new RoutingServiceBusTopicEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.id = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.connectionString = reader.getString();
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.endpointUri = reader.getString();
                    continue;
                }
                if ("entityPath".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.entityPath = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedRoutingServiceBusTopicEndpointProperties.resourceGroup = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingServiceBusTopicEndpointProperties;
        });
    }
}

