/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import com.azure.resourcemanager.iothub.models.RoutingStorageContainerPropertiesEncoding;
import java.io.IOException;

public final class RoutingStorageContainerProperties
implements JsonSerializable<RoutingStorageContainerProperties> {
    private String id;
    private String connectionString;
    private String endpointUri;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private String name;
    private String subscriptionId;
    private String resourceGroup;
    private String containerName;
    private String fileNameFormat;
    private Integer batchFrequencyInSeconds;
    private Integer maxChunkSizeInBytes;
    private RoutingStorageContainerPropertiesEncoding encoding;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingStorageContainerProperties.class);

    public String id() {
        return this.id;
    }

    public RoutingStorageContainerProperties withId(String id) {
        this.id = id;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public RoutingStorageContainerProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public RoutingStorageContainerProperties withEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public RoutingStorageContainerProperties withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public RoutingStorageContainerProperties withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String name() {
        return this.name;
    }

    public RoutingStorageContainerProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public RoutingStorageContainerProperties withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public RoutingStorageContainerProperties withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public RoutingStorageContainerProperties withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String fileNameFormat() {
        return this.fileNameFormat;
    }

    public RoutingStorageContainerProperties withFileNameFormat(String fileNameFormat) {
        this.fileNameFormat = fileNameFormat;
        return this;
    }

    public Integer batchFrequencyInSeconds() {
        return this.batchFrequencyInSeconds;
    }

    public RoutingStorageContainerProperties withBatchFrequencyInSeconds(Integer batchFrequencyInSeconds) {
        this.batchFrequencyInSeconds = batchFrequencyInSeconds;
        return this;
    }

    public Integer maxChunkSizeInBytes() {
        return this.maxChunkSizeInBytes;
    }

    public RoutingStorageContainerProperties withMaxChunkSizeInBytes(Integer maxChunkSizeInBytes) {
        this.maxChunkSizeInBytes = maxChunkSizeInBytes;
        return this;
    }

    public RoutingStorageContainerPropertiesEncoding encoding() {
        return this.encoding;
    }

    public RoutingStorageContainerProperties withEncoding(RoutingStorageContainerPropertiesEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RoutingStorageContainerProperties"));
        }
        if (this.containerName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerName in model RoutingStorageContainerProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("endpointUri", this.endpointUri);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("fileNameFormat", this.fileNameFormat);
        jsonWriter.writeNumberField("batchFrequencyInSeconds", (Number)this.batchFrequencyInSeconds);
        jsonWriter.writeNumberField("maxChunkSizeInBytes", (Number)this.maxChunkSizeInBytes);
        jsonWriter.writeStringField("encoding", this.encoding == null ? null : this.encoding.toString());
        return jsonWriter.writeEndObject();
    }

    public static RoutingStorageContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingStorageContainerProperties)jsonReader.readObject(reader -> {
            RoutingStorageContainerProperties deserializedRoutingStorageContainerProperties = new RoutingStorageContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.name = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.containerName = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.id = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.connectionString = reader.getString();
                    continue;
                }
                if ("endpointUri".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.endpointUri = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.resourceGroup = reader.getString();
                    continue;
                }
                if ("fileNameFormat".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.fileNameFormat = reader.getString();
                    continue;
                }
                if ("batchFrequencyInSeconds".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.batchFrequencyInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxChunkSizeInBytes".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.maxChunkSizeInBytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encoding".equals(fieldName)) {
                    deserializedRoutingStorageContainerProperties.encoding = RoutingStorageContainerPropertiesEncoding.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingStorageContainerProperties;
        });
    }
}

