/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import java.io.IOException;
import java.time.Duration;

public final class StorageEndpointProperties
implements JsonSerializable<StorageEndpointProperties> {
    private Duration sasTtlAsIso8601;
    private String connectionString;
    private String containerName;
    private AuthenticationType authenticationType;
    private ManagedIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(StorageEndpointProperties.class);

    public Duration sasTtlAsIso8601() {
        return this.sasTtlAsIso8601;
    }

    public StorageEndpointProperties withSasTtlAsIso8601(Duration sasTtlAsIso8601) {
        this.sasTtlAsIso8601 = sasTtlAsIso8601;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public StorageEndpointProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String containerName() {
        return this.containerName;
    }

    public StorageEndpointProperties withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public StorageEndpointProperties withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public StorageEndpointProperties withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model StorageEndpointProperties"));
        }
        if (this.containerName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property containerName in model StorageEndpointProperties"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("sasTtlAsIso8601", CoreUtils.durationToStringWithDays((Duration)this.sasTtlAsIso8601));
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static StorageEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageEndpointProperties)jsonReader.readObject(reader -> {
            StorageEndpointProperties deserializedStorageEndpointProperties = new StorageEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedStorageEndpointProperties.connectionString = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedStorageEndpointProperties.containerName = reader.getString();
                    continue;
                }
                if ("sasTtlAsIso8601".equals(fieldName)) {
                    deserializedStorageEndpointProperties.sasTtlAsIso8601 = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedStorageEndpointProperties.authenticationType = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedStorageEndpointProperties.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageEndpointProperties;
        });
    }
}

