/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RoutingMessage;
import com.azure.resourcemanager.iothub.models.RoutingSource;
import com.azure.resourcemanager.iothub.models.RoutingTwin;
import java.io.IOException;

public final class TestAllRoutesInput
implements JsonSerializable<TestAllRoutesInput> {
    private RoutingSource routingSource;
    private RoutingMessage message;
    private RoutingTwin twin;

    public RoutingSource routingSource() {
        return this.routingSource;
    }

    public TestAllRoutesInput withRoutingSource(RoutingSource routingSource) {
        this.routingSource = routingSource;
        return this;
    }

    public RoutingMessage message() {
        return this.message;
    }

    public TestAllRoutesInput withMessage(RoutingMessage message) {
        this.message = message;
        return this;
    }

    public RoutingTwin twin() {
        return this.twin;
    }

    public TestAllRoutesInput withTwin(RoutingTwin twin) {
        this.twin = twin;
        return this;
    }

    public void validate() {
        if (this.message() != null) {
            this.message().validate();
        }
        if (this.twin() != null) {
            this.twin().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("routingSource", this.routingSource == null ? null : this.routingSource.toString());
        jsonWriter.writeJsonField("message", (JsonSerializable)this.message);
        jsonWriter.writeJsonField("twin", (JsonSerializable)this.twin);
        return jsonWriter.writeEndObject();
    }

    public static TestAllRoutesInput fromJson(JsonReader jsonReader) throws IOException {
        return (TestAllRoutesInput)jsonReader.readObject(reader -> {
            TestAllRoutesInput deserializedTestAllRoutesInput = new TestAllRoutesInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routingSource".equals(fieldName)) {
                    deserializedTestAllRoutesInput.routingSource = RoutingSource.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedTestAllRoutesInput.message = RoutingMessage.fromJson(reader);
                    continue;
                }
                if ("twin".equals(fieldName)) {
                    deserializedTestAllRoutesInput.twin = RoutingTwin.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestAllRoutesInput;
        });
    }
}

