/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.RouteProperties;
import com.azure.resourcemanager.iothub.models.RoutingMessage;
import com.azure.resourcemanager.iothub.models.RoutingTwin;
import java.io.IOException;

public final class TestRouteInput
implements JsonSerializable<TestRouteInput> {
    private RoutingMessage message;
    private RouteProperties route;
    private RoutingTwin twin;
    private static final ClientLogger LOGGER = new ClientLogger(TestRouteInput.class);

    public RoutingMessage message() {
        return this.message;
    }

    public TestRouteInput withMessage(RoutingMessage message) {
        this.message = message;
        return this;
    }

    public RouteProperties route() {
        return this.route;
    }

    public TestRouteInput withRoute(RouteProperties route) {
        this.route = route;
        return this;
    }

    public RoutingTwin twin() {
        return this.twin;
    }

    public TestRouteInput withTwin(RoutingTwin twin) {
        this.twin = twin;
        return this;
    }

    public void validate() {
        if (this.message() != null) {
            this.message().validate();
        }
        if (this.route() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property route in model TestRouteInput"));
        }
        this.route().validate();
        if (this.twin() != null) {
            this.twin().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("route", (JsonSerializable)this.route);
        jsonWriter.writeJsonField("message", (JsonSerializable)this.message);
        jsonWriter.writeJsonField("twin", (JsonSerializable)this.twin);
        return jsonWriter.writeEndObject();
    }

    public static TestRouteInput fromJson(JsonReader jsonReader) throws IOException {
        return (TestRouteInput)jsonReader.readObject(reader -> {
            TestRouteInput deserializedTestRouteInput = new TestRouteInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("route".equals(fieldName)) {
                    deserializedTestRouteInput.route = RouteProperties.fromJson(reader);
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedTestRouteInput.message = RoutingMessage.fromJson(reader);
                    continue;
                }
                if ("twin".equals(fieldName)) {
                    deserializedTestRouteInput.twin = RoutingTwin.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestRouteInput;
        });
    }
}

