/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.Name;
import java.io.IOException;

public final class UserSubscriptionQuota
implements JsonSerializable<UserSubscriptionQuota> {
    private String id;
    private String type;
    private String unit;
    private Integer currentValue;
    private Integer limit;
    private Name name;

    public String id() {
        return this.id;
    }

    public UserSubscriptionQuota withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public UserSubscriptionQuota withType(String type) {
        this.type = type;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public UserSubscriptionQuota withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public Integer currentValue() {
        return this.currentValue;
    }

    public UserSubscriptionQuota withCurrentValue(Integer currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public Integer limit() {
        return this.limit;
    }

    public UserSubscriptionQuota withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Name name() {
        return this.name;
    }

    public UserSubscriptionQuota withName(Name name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeNumberField("currentValue", (Number)this.currentValue);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        return jsonWriter.writeEndObject();
    }

    public static UserSubscriptionQuota fromJson(JsonReader jsonReader) throws IOException {
        return (UserSubscriptionQuota)jsonReader.readObject(reader -> {
            UserSubscriptionQuota deserializedUserSubscriptionQuota = new UserSubscriptionQuota();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedUserSubscriptionQuota.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUserSubscriptionQuota.type = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedUserSubscriptionQuota.unit = reader.getString();
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedUserSubscriptionQuota.currentValue = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedUserSubscriptionQuota.limit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUserSubscriptionQuota.name = Name.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserSubscriptionQuota;
        });
    }
}

