// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The VaultPatchParameters model. */
@Fluent
public final class VaultPatchParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(VaultPatchParameters.class);

    /*
     * The tags that will be assigned to the key vault.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * Properties of the vault
     */
    @JsonProperty(value = "properties")
    private VaultPatchProperties properties;

    /**
     * Get the tags property: The tags that will be assigned to the key vault.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags that will be assigned to the key vault.
     *
     * @param tags the tags value to set.
     * @return the VaultPatchParameters object itself.
     */
    public VaultPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: Properties of the vault.
     *
     * @return the properties value.
     */
    public VaultPatchProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the vault.
     *
     * @param properties the properties value to set.
     * @return the VaultPatchParameters object itself.
     */
    public VaultPatchParameters withProperties(VaultPatchProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
