/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.Resource;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.keyvault.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.fluent.inner.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.keyvault.fluent.inner.DeletedVaultInner;
import com.azure.resourcemanager.keyvault.fluent.inner.DeletedVaultListResultInner;
import com.azure.resourcemanager.keyvault.fluent.inner.ResourceListResultInner;
import com.azure.resourcemanager.keyvault.fluent.inner.VaultAccessPolicyParametersInner;
import com.azure.resourcemanager.keyvault.fluent.inner.VaultInner;
import com.azure.resourcemanager.keyvault.fluent.inner.VaultListResultInner;
import com.azure.resourcemanager.keyvault.models.AccessPolicyUpdateKind;
import com.azure.resourcemanager.keyvault.models.VaultAccessPolicyProperties;
import com.azure.resourcemanager.keyvault.models.VaultCheckNameAvailabilityParameters;
import com.azure.resourcemanager.keyvault.models.VaultCreateOrUpdateParameters;
import com.azure.resourcemanager.keyvault.models.VaultPatchParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VaultsClient
implements InnerSupportsGet<VaultInner>,
InnerSupportsDelete<Void> {
    private final ClientLogger logger = new ClientLogger(VaultsClient.class);
    private final VaultsService service;
    private final KeyVaultManagementClient client;

    public VaultsClient(KeyVaultManagementClient client) {
        this.service = (VaultsService)RestProxy.create(VaultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    public PollerFlux<PollResult<VaultInner>, VaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, parameters);
        return this.client.getLroResultAsync((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VaultInner.class), (Type)((Object)VaultInner.class));
    }

    public PollerFlux<PollResult<VaultInner>, VaultInner> beginCreateOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, Context context) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, parameters, context);
        return this.client.getLroResultAsync((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VaultInner.class), (Type)((Object)VaultInner.class));
    }

    public SyncPoller<PollResult<VaultInner>, VaultInner> beginCreateOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vaultName, parameters).getSyncPoller();
    }

    public SyncPoller<PollResult<VaultInner>, VaultInner> beginCreateOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vaultName, parameters, context).getSyncPoller();
    }

    public Mono<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vaultName, parameters).last().flatMap(arg_0 -> ((KeyVaultManagementClient)this.client).getLroFinalResultOrError(arg_0));
    }

    public Mono<VaultInner> createOrUpdateAsync(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vaultName, parameters, context).last().flatMap(arg_0 -> ((KeyVaultManagementClient)this.client).getLroFinalResultOrError(arg_0));
    }

    public VaultInner createOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters) {
        return (VaultInner)((Object)this.createOrUpdateAsync(resourceGroupName, vaultName, parameters).block());
    }

    public VaultInner createOrUpdate(String resourceGroupName, String vaultName, VaultCreateOrUpdateParameters parameters, Context context) {
        return (VaultInner)((Object)this.createOrUpdateAsync(resourceGroupName, vaultName, parameters, context).block());
    }

    public Mono<Response<VaultInner>> updateWithResponseAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<VaultInner>> updateWithResponseAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.update(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    public Mono<VaultInner> updateAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        return this.updateWithResponseAsync(resourceGroupName, vaultName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public Mono<VaultInner> updateAsync(String resourceGroupName, String vaultName, VaultPatchParameters parameters, Context context) {
        return this.updateWithResponseAsync(resourceGroupName, vaultName, parameters, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public VaultInner update(String resourceGroupName, String vaultName, VaultPatchParameters parameters) {
        return (VaultInner)((Object)this.updateAsync(resourceGroupName, vaultName, parameters).block());
    }

    public VaultInner update(String resourceGroupName, String vaultName, VaultPatchParameters parameters, Context context) {
        return (VaultInner)((Object)this.updateAsync(resourceGroupName, vaultName, parameters, context).block());
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String vaultName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    public Mono<Void> deleteAsync(String resourceGroupName, String vaultName) {
        return this.deleteWithResponseAsync(resourceGroupName, vaultName).flatMap(res -> Mono.empty());
    }

    public Mono<Void> deleteAsync(String resourceGroupName, String vaultName, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, vaultName, context).flatMap(res -> Mono.empty());
    }

    public void delete(String resourceGroupName, String vaultName) {
        this.deleteAsync(resourceGroupName, vaultName).block();
    }

    public void delete(String resourceGroupName, String vaultName, Context context) {
        this.deleteAsync(resourceGroupName, vaultName, context).block();
    }

    public Mono<Response<VaultInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<VaultInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String vaultName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, vaultName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    public Mono<VaultInner> getByResourceGroupAsync(String resourceGroupName, String vaultName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, vaultName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public Mono<VaultInner> getByResourceGroupAsync(String resourceGroupName, String vaultName, Context context) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, vaultName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public VaultInner getByResourceGroup(String resourceGroupName, String vaultName) {
        return (VaultInner)((Object)this.getByResourceGroupAsync(resourceGroupName, vaultName).block());
    }

    public VaultInner getByResourceGroup(String resourceGroupName, String vaultName, Context context) {
        return (VaultInner)((Object)this.getByResourceGroupAsync(resourceGroupName, vaultName, context).block());
    }

    public Mono<Response<VaultAccessPolicyParametersInner>> updateAccessPolicyWithResponseAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (operationKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationKind is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        VaultAccessPolicyParametersInner parameters = new VaultAccessPolicyParametersInner();
        parameters.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updateAccessPolicy(this.client.getEndpoint(), resourceGroupName, vaultName, operationKind, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<VaultAccessPolicyParametersInner>> updateAccessPolicyWithResponseAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (operationKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationKind is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        VaultAccessPolicyParametersInner parameters = new VaultAccessPolicyParametersInner();
        parameters.withProperties(properties);
        return this.service.updateAccessPolicy(this.client.getEndpoint(), resourceGroupName, vaultName, operationKind, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    public Mono<VaultAccessPolicyParametersInner> updateAccessPolicyAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        return this.updateAccessPolicyWithResponseAsync(resourceGroupName, vaultName, operationKind, properties).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public Mono<VaultAccessPolicyParametersInner> updateAccessPolicyAsync(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties, Context context) {
        return this.updateAccessPolicyWithResponseAsync(resourceGroupName, vaultName, operationKind, properties, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public VaultAccessPolicyParametersInner updateAccessPolicy(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties) {
        return (VaultAccessPolicyParametersInner)((Object)this.updateAccessPolicyAsync(resourceGroupName, vaultName, operationKind, properties).block());
    }

    public VaultAccessPolicyParametersInner updateAccessPolicy(String resourceGroupName, String vaultName, AccessPolicyUpdateKind operationKind, VaultAccessPolicyProperties properties, Context context) {
        return (VaultAccessPolicyParametersInner)((Object)this.updateAccessPolicyAsync(resourceGroupName, vaultName, operationKind, properties, context).block());
    }

    public Mono<PagedResponse<VaultInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, top, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<VaultInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, top, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null));
    }

    public PagedFlux<VaultInner> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<VaultInner> listByResourceGroupAsync(String resourceGroupName, Integer top, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<VaultInner> listByResourceGroupAsync(String resourceGroupName) {
        Integer top = null;
        Object context = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    public PagedIterable<VaultInner> listByResourceGroup(String resourceGroupName, Integer top) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top));
    }

    public PagedIterable<VaultInner> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top, context));
    }

    public PagedIterable<VaultInner> listByResourceGroup(String resourceGroupName) {
        Integer top = null;
        Object context = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, top));
    }

    public Mono<PagedResponse<VaultInner>> listBySubscriptionSinglePageAsync(Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBySubscription(this.client.getEndpoint(), top, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<VaultInner>> listBySubscriptionSinglePageAsync(Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.listBySubscription(this.client.getEndpoint(), top, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null));
    }

    public PagedFlux<VaultInner> listBySubscriptionAsync(Integer top) {
        return new PagedFlux(() -> this.listBySubscriptionSinglePageAsync(top), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<VaultInner> listBySubscriptionAsync(Integer top, Context context) {
        return new PagedFlux(() -> this.listBySubscriptionSinglePageAsync(top, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<VaultInner> listBySubscriptionAsync() {
        Integer top = null;
        Object context = null;
        return new PagedFlux(() -> this.listBySubscriptionSinglePageAsync(top), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    public PagedIterable<VaultInner> listBySubscription(Integer top) {
        return new PagedIterable(this.listBySubscriptionAsync(top));
    }

    public PagedIterable<VaultInner> listBySubscription(Integer top, Context context) {
        return new PagedIterable(this.listBySubscriptionAsync(top, context));
    }

    public PagedIterable<VaultInner> listBySubscription() {
        Integer top = null;
        Object context = null;
        return new PagedIterable(this.listBySubscriptionAsync(top));
    }

    public Mono<PagedResponse<DeletedVaultInner>> listDeletedSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listDeleted(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedVaultListResultInner)res.getValue()).value(), ((DeletedVaultListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<DeletedVaultInner>> listDeletedSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.listDeleted(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedVaultListResultInner)res.getValue()).value(), ((DeletedVaultListResultInner)res.getValue()).nextLink(), null));
    }

    public PagedFlux<DeletedVaultInner> listDeletedAsync() {
        return new PagedFlux(() -> this.listDeletedSinglePageAsync(), nextLink -> this.listDeletedNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<DeletedVaultInner> listDeletedAsync(Context context) {
        return new PagedFlux(() -> this.listDeletedSinglePageAsync(context), nextLink -> this.listDeletedNextSinglePageAsync((String)nextLink));
    }

    public PagedIterable<DeletedVaultInner> listDeleted() {
        return new PagedIterable(this.listDeletedAsync());
    }

    public PagedIterable<DeletedVaultInner> listDeleted(Context context) {
        return new PagedIterable(this.listDeletedAsync(context));
    }

    public Mono<Response<DeletedVaultInner>> getDeletedWithResponseAsync(String vaultName, String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getDeleted(this.client.getEndpoint(), vaultName, location, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<DeletedVaultInner>> getDeletedWithResponseAsync(String vaultName, String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.getDeleted(this.client.getEndpoint(), vaultName, location, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    public Mono<DeletedVaultInner> getDeletedAsync(String vaultName, String location) {
        return this.getDeletedWithResponseAsync(vaultName, location).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public Mono<DeletedVaultInner> getDeletedAsync(String vaultName, String location, Context context) {
        return this.getDeletedWithResponseAsync(vaultName, location, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public DeletedVaultInner getDeleted(String vaultName, String location) {
        return (DeletedVaultInner)this.getDeletedAsync(vaultName, location).block();
    }

    public DeletedVaultInner getDeleted(String vaultName, String location, Context context) {
        return (DeletedVaultInner)this.getDeletedAsync(vaultName, location, context).block();
    }

    public Mono<Response<Flux<ByteBuffer>>> purgeDeletedWithResponseAsync(String vaultName, String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.purgeDeleted(this.client.getEndpoint(), vaultName, location, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<Flux<ByteBuffer>>> purgeDeletedWithResponseAsync(String vaultName, String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.purgeDeleted(this.client.getEndpoint(), vaultName, location, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    public PollerFlux<PollResult<Void>, Void> beginPurgeDeletedAsync(String vaultName, String location) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeDeletedWithResponseAsync(vaultName, location);
        return this.client.getLroResultAsync((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class));
    }

    public PollerFlux<PollResult<Void>, Void> beginPurgeDeletedAsync(String vaultName, String location, Context context) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeDeletedWithResponseAsync(vaultName, location, context);
        return this.client.getLroResultAsync((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class));
    }

    public SyncPoller<PollResult<Void>, Void> beginPurgeDeleted(String vaultName, String location) {
        return this.beginPurgeDeletedAsync(vaultName, location).getSyncPoller();
    }

    public SyncPoller<PollResult<Void>, Void> beginPurgeDeleted(String vaultName, String location, Context context) {
        return this.beginPurgeDeletedAsync(vaultName, location, context).getSyncPoller();
    }

    public Mono<Void> purgeDeletedAsync(String vaultName, String location) {
        return this.beginPurgeDeletedAsync(vaultName, location).last().flatMap(arg_0 -> ((KeyVaultManagementClient)this.client).getLroFinalResultOrError(arg_0));
    }

    public Mono<Void> purgeDeletedAsync(String vaultName, String location, Context context) {
        return this.beginPurgeDeletedAsync(vaultName, location, context).last().flatMap(arg_0 -> ((KeyVaultManagementClient)this.client).getLroFinalResultOrError(arg_0));
    }

    public void purgeDeleted(String vaultName, String location) {
        this.purgeDeletedAsync(vaultName, location).block();
    }

    public void purgeDeleted(String vaultName, String location, Context context) {
        this.purgeDeletedAsync(vaultName, location, context).block();
    }

    public Mono<PagedResponse<Resource>> listSinglePageAsync(Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "resourceType eq 'Microsoft.KeyVault/vaults'", top, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResultInner)res.getValue()).value(), ((ResourceListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<Resource>> listSinglePageAsync(Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String filter = "resourceType eq 'Microsoft.KeyVault/vaults'";
        return this.service.list(this.client.getEndpoint(), "resourceType eq 'Microsoft.KeyVault/vaults'", top, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResultInner)res.getValue()).value(), ((ResourceListResultInner)res.getValue()).nextLink(), null));
    }

    public PagedFlux<Resource> listAsync(Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<Resource> listAsync(Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    public PagedFlux<Resource> listAsync() {
        Integer top = null;
        Object context = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    public PagedIterable<Resource> list(Integer top) {
        return new PagedIterable(this.listAsync(top));
    }

    public PagedIterable<Resource> list(Integer top, Context context) {
        return new PagedIterable(this.listAsync(top, context));
    }

    public PagedIterable<Resource> list() {
        Integer top = null;
        Object context = null;
        return new PagedIterable(this.listAsync(top));
    }

    public Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        VaultCheckNameAvailabilityParameters vaultName = new VaultCheckNameAvailabilityParameters();
        vaultName.withName(name);
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), vaultName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        VaultCheckNameAvailabilityParameters vaultName = new VaultCheckNameAvailabilityParameters();
        vaultName.withName(name);
        return this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), vaultName, context);
    }

    public Mono<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithResponseAsync(name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public Mono<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name, Context context) {
        return this.checkNameAvailabilityWithResponseAsync(name, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityResultInner)this.checkNameAvailabilityAsync(name).block();
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String name, Context context) {
        return (CheckNameAvailabilityResultInner)this.checkNameAvailabilityAsync(name, context).block();
    }

    public Mono<PagedResponse<VaultInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<VaultInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return this.service.listByResourceGroupNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null));
    }

    public Mono<PagedResponse<VaultInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<VaultInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return this.service.listBySubscriptionNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VaultListResultInner)res.getValue()).value(), ((VaultListResultInner)res.getValue()).nextLink(), null));
    }

    public Mono<PagedResponse<DeletedVaultInner>> listDeletedNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listDeletedNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedVaultListResultInner)res.getValue()).value(), ((DeletedVaultListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<DeletedVaultInner>> listDeletedNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return this.service.listDeletedNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedVaultListResultInner)res.getValue()).value(), ((DeletedVaultListResultInner)res.getValue()).nextLink(), null));
    }

    public Mono<PagedResponse<Resource>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResultInner)res.getValue()).value(), ((ResourceListResultInner)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    public Mono<PagedResponse<Resource>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResultInner)res.getValue()).value(), ((ResourceListResultInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KeyVaultManagementCl")
    private static interface VaultsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vaultName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VaultCreateOrUpdateParameters var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vaultName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VaultPatchParameters var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vaultName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vaultName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/accessPolicies/{operationKind}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultAccessPolicyParametersInner>> updateAccessPolicy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vaultName") String var3, @PathParam(value="operationKind") AccessPolicyUpdateKind var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") VaultAccessPolicyParametersInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultListResultInner>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/vaults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultListResultInner>> listBySubscription(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/deletedVaults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedVaultListResultInner>> listDeleted(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedVaultInner>> getDeleted(@HostParam(value="$host") String var1, @PathParam(value="vaultName") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> purgeDeleted(@HostParam(value="$host") String var1, @PathParam(value="vaultName") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListResultInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailability(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") VaultCheckNameAvailabilityParameters var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultListResultInner>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VaultListResultInner>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeletedVaultListResultInner>> listDeletedNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListResultInner>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

