/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.resourcemanager.keyvault.implementation.KeyImpl;
import com.azure.resourcemanager.keyvault.models.Key;
import com.azure.resourcemanager.keyvault.models.Keys;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.net.MalformedURLException;
import java.net.URL;
import reactor.core.publisher.Mono;

class KeysImpl
extends CreatableWrappersImpl<Key, KeyImpl, KeyVaultKey>
implements Keys {
    private final KeyAsyncClient inner;
    private final Vault vault;

    KeysImpl(KeyAsyncClient client, Vault vault) {
        this.inner = client;
        this.vault = vault;
    }

    public KeyImpl define(String name) {
        return this.wrapModel(name);
    }

    protected KeyImpl wrapModel(String name) {
        return new KeyImpl(name, null, this.vault);
    }

    public Key getById(String id) {
        return (Key)this.getByIdAsync(id).block();
    }

    public Mono<Key> getByIdAsync(String id) {
        String name = KeysImpl.nameFromId(id);
        return this.inner.getKey(name).map(this::wrapModel);
    }

    protected KeyImpl wrapModel(KeyVaultKey inner) {
        if (inner == null) {
            return null;
        }
        return new KeyImpl(inner.getName(), inner, this.vault);
    }

    public Mono<Void> deleteByIdAsync(String id) {
        String name = KeysImpl.nameFromId(id);
        return this.inner.beginDeleteKey(name).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
                return asyncPollResponse.getFinalResult();
            }
            return Mono.error((Throwable)new RuntimeException("polling completed unsuccessfully with status:" + asyncPollResponse.getStatus()));
        });
    }

    public PagedIterable<Key> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<Key> listAsync() {
        return PagedConverter.flatMapPage((PagedFlux)this.inner.listPropertiesOfKeys(), p -> this.inner.getKey(p.getName()).map(this::wrapModel));
    }

    @Override
    public Key getByNameAndVersion(String name, String version) {
        return (Key)this.getByNameAndVersionAsync(name, version).block();
    }

    @Override
    public Mono<Key> getByNameAndVersionAsync(String name, String version) {
        return this.inner.getKey(name, version).map(this::wrapModel);
    }

    @Override
    public Key restore(byte[] backup) {
        return (Key)this.restoreAsync(backup).block();
    }

    @Override
    public Mono<Key> restoreAsync(byte[] backup) {
        return this.inner.restoreKeyBackup(backup).map(this::wrapModel);
    }

    public Mono<Key> getByNameAsync(String name) {
        return this.inner.getKey(name).map(this::wrapModel);
    }

    public Key getByName(String name) {
        return (Key)this.getByNameAsync(name).block();
    }

    private static String nameFromId(String id) {
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            String name = tokens.length >= 3 ? tokens[2] : null;
            return name;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Received Malformed Id URL from KV Service");
        }
    }
}

