/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.resourcemanager.keyvault.models.Secret;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.Utils;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SecretImpl
extends CreatableUpdatableImpl<Secret, KeyVaultSecret, SecretImpl>
implements Secret,
Secret.Definition,
Secret.Update {
    private final Vault vault;
    private String valueToSet;

    SecretImpl(String name, KeyVaultSecret innerObject, Vault vault) {
        super(name, (Object)innerObject);
        this.vault = vault;
    }

    private SecretImpl wrapModel(KeyVaultSecret secret) {
        return new SecretImpl(secret.getName(), secret, this.vault);
    }

    public String id() {
        return ((KeyVaultSecret)this.inner()).getId();
    }

    @Override
    public String value() {
        return ((KeyVaultSecret)this.inner()).getValue();
    }

    @Override
    public SecretProperties attributes() {
        return ((KeyVaultSecret)this.inner()).getProperties();
    }

    @Override
    public Map<String, String> tags() {
        return ((KeyVaultSecret)this.inner()).getProperties().getTags();
    }

    @Override
    public String contentType() {
        return ((KeyVaultSecret)this.inner()).getProperties().getContentType();
    }

    @Override
    public String kid() {
        return ((KeyVaultSecret)this.inner()).getProperties().getKeyId();
    }

    @Override
    public boolean managed() {
        return Utils.toPrimitiveBoolean((Boolean)((KeyVaultSecret)this.inner()).getProperties().isManaged());
    }

    @Override
    public Iterable<Secret> listVersions() {
        return this.listVersionsAsync().toIterable();
    }

    @Override
    public Flux<Secret> listVersionsAsync() {
        return this.vault.secretClient().listPropertiesOfSecretVersions(this.name()).flatMap(p -> this.vault.secretClient().getSecret(p.getName(), p.getVersion())).map(this::wrapModel);
    }

    protected Mono<KeyVaultSecret> getInnerAsync() {
        return this.vault.secretClient().getSecret(this.name(), null);
    }

    @Override
    public SecretImpl withTags(Map<String, String> tags) {
        ((KeyVaultSecret)this.inner()).getProperties().setTags(tags);
        return this;
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<Secret> createResourceAsync() {
        KeyVaultSecret newSecret = new KeyVaultSecret(this.name(), this.valueToSet);
        newSecret.setProperties(this.attributes());
        return this.vault.secretClient().setSecret(newSecret).map(inner -> {
            this.setInner(inner);
            this.valueToSet = null;
            return this;
        });
    }

    public Mono<Secret> updateResourceAsync() {
        if (this.valueToSet == null) {
            return this.vault.secretClient().updateSecretProperties(this.attributes()).map(p -> {
                ((KeyVaultSecret)this.inner()).setProperties(p);
                return this;
            });
        }
        return this.createResourceAsync();
    }

    @Override
    public SecretImpl withAttributes(SecretProperties attributes) {
        ((KeyVaultSecret)this.inner()).setProperties(attributes);
        return this;
    }

    @Override
    public SecretImpl withValue(String value) {
        Objects.requireNonNull(value);
        this.valueToSet = value;
        return this;
    }

    @Override
    public SecretImpl withContentType(String contentType) {
        ((KeyVaultSecret)this.inner()).getProperties().setContentType(contentType);
        return this;
    }
}

