// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.fluent.inner;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The DeletedVaultListResult model. */
@Fluent
public final class DeletedVaultListResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DeletedVaultListResultInner.class);

    /*
     * The list of deleted vaults.
     */
    @JsonProperty(value = "value")
    private List<DeletedVaultInner> value;

    /*
     * The URL to get the next set of deleted vaults.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The list of deleted vaults.
     *
     * @return the value value.
     */
    public List<DeletedVaultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of deleted vaults.
     *
     * @param value the value value to set.
     * @return the DeletedVaultListResultInner object itself.
     */
    public DeletedVaultListResultInner withValue(List<DeletedVaultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of deleted vaults.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of deleted vaults.
     *
     * @param nextLink the nextLink value to set.
     * @return the DeletedVaultListResultInner object itself.
     */
    public DeletedVaultListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
