/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.keyvault.fluent.OperationsClient;
import com.azure.resourcemanager.keyvault.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.keyvault.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.keyvault.fluent.VaultsClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

public final class KeyVaultManagementClient
extends AzureServiceClient {
    private final ClientLogger logger = new ClientLogger(KeyVaultManagementClient.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final VaultsClient vaults;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final OperationsClient operations;

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    public VaultsClient getVaults() {
        return this.vaults;
    }

    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    public OperationsClient getOperations() {
        return this.operations;
    }

    KeyVaultManagementClient(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2018-02-14";
        this.vaults = new VaultsClient(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClient(this);
        this.privateLinkResources = new PrivateLinkResourcesClient(this);
        this.operations = new OperationsClient(this);
    }
}

