/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.resourcemanager.keyvault.implementation.SecretImpl;
import com.azure.resourcemanager.keyvault.models.Secret;
import com.azure.resourcemanager.keyvault.models.Secrets;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.net.MalformedURLException;
import java.net.URL;
import reactor.core.publisher.Mono;

class SecretsImpl
extends CreatableWrappersImpl<Secret, SecretImpl, KeyVaultSecret>
implements Secrets {
    private final SecretAsyncClient inner;
    private final Vault vault;

    SecretsImpl(SecretAsyncClient client, Vault vault) {
        this.inner = client;
        this.vault = vault;
    }

    public SecretImpl define(String name) {
        return this.wrapModel(name);
    }

    protected SecretImpl wrapModel(String name) {
        return new SecretImpl(name, new KeyVaultSecret(name, null), this.vault);
    }

    public Secret getById(String id) {
        return (Secret)this.getByIdAsync(id).block();
    }

    public Mono<Secret> getByIdAsync(String id) {
        String name = SecretsImpl.nameFromId(id);
        return this.inner.getSecret(name).map(this::wrapModel);
    }

    protected SecretImpl wrapModel(KeyVaultSecret inner) {
        if (inner == null) {
            return null;
        }
        return new SecretImpl(inner.getName(), inner, this.vault);
    }

    public Mono<Void> deleteByIdAsync(String id) {
        String name = SecretsImpl.nameFromId(id);
        return this.inner.beginDeleteSecret(name).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
                return asyncPollResponse.getFinalResult();
            }
            return Mono.error((Throwable)new RuntimeException("polling completed unsuccessfully with status:" + asyncPollResponse.getStatus()));
        });
    }

    public PagedIterable<Secret> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<Secret> listAsync() {
        return PagedConverter.flatMapPage((PagedFlux)this.inner.listPropertiesOfSecrets(), s -> {
            if (s.isEnabled().booleanValue()) {
                return this.vault.secretClient().getSecret(s.getName(), s.getVersion()).map(this::wrapModel);
            }
            return Mono.just((Object)this.wrapModel(new KeyVaultSecret(s.getName(), null).setProperties(s)));
        });
    }

    public Mono<Secret> getByNameAsync(String name) {
        return this.inner.getSecret(name).map(this::wrapModel);
    }

    public Secret getByName(String name) {
        return (Secret)this.getByNameAsync(name).block();
    }

    @Override
    public Secret getByNameAndVersion(String name, String version) {
        return (Secret)this.getByNameAndVersionAsync(name, version).block();
    }

    @Override
    public Mono<Secret> getByNameAndVersionAsync(String name, String version) {
        return this.inner.getSecret(name, version).map(this::wrapModel);
    }

    private static String nameFromId(String id) {
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            String name = tokens.length >= 3 ? tokens[2] : null;
            return name;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Received Malformed Id URL from KV Service");
        }
    }
}

