/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.http.HttpPipeline;
import com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.azure.resourcemanager.keyvault.fluent.inner.VaultInner;
import com.azure.resourcemanager.keyvault.models.AccessPolicy;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.Keys;
import com.azure.resourcemanager.keyvault.models.NetworkRuleAction;
import com.azure.resourcemanager.keyvault.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.keyvault.models.NetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.Secrets;
import com.azure.resourcemanager.keyvault.models.Sku;
import com.azure.resourcemanager.keyvault.models.SkuName;
import com.azure.resourcemanager.keyvault.models.VirtualNetworkRule;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import java.util.List;

public interface Vault
extends GroupableResource<KeyVaultManager, VaultInner>,
Refreshable<Vault>,
Updatable<Update> {
    public SecretAsyncClient secretClient();

    public KeyAsyncClient keyClient();

    public HttpPipeline vaultHttpPipeline();

    public Keys keys();

    public Secrets secrets();

    public String vaultUri();

    public String tenantId();

    public Sku sku();

    public List<AccessPolicy> accessPolicies();

    public boolean enabledForDeployment();

    public boolean enabledForDiskEncryption();

    public boolean enabledForTemplateDeployment();

    public boolean softDeleteEnabled();

    public boolean purgeProtectionEnabled();

    public CreateMode createMode();

    public NetworkRuleSet networkRuleSet();

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<Vault>,
    UpdateStages.WithAccessPolicy,
    UpdateStages.WithNetworkRuleSet,
    UpdateStages.WithConfigurations {
    }

    public static interface UpdateStages {

        public static interface WithConfigurations {
            public Update withDeploymentEnabled();

            public Update withDiskEncryptionEnabled();

            public Update withTemplateDeploymentEnabled();

            public Update withSoftDeleteEnabled();

            public Update withPurgeProtectionEnabled();

            public Update withDeploymentDisabled();

            public Update withDiskEncryptionDisabled();

            public Update withTemplateDeploymentDisabled();
        }

        public static interface WithNetworkRuleSet {
            public Update withAccessFromAllNetworks();

            public Update withAccessFromSelectedNetworks();

            public Update withAccessFromIpAddress(String var1);

            public Update withAccessFromIpAddressRange(String var1);

            public Update withAccessFromAzureServices();

            public Update withBypass(NetworkRuleBypassOptions var1);

            public Update withDefaultAction(NetworkRuleAction var1);

            public Update withVirtualNetworkRules(List<VirtualNetworkRule> var1);
        }

        public static interface WithAccessPolicy {
            public Update withoutAccessPolicy(String var1);

            public Update withAccessPolicy(AccessPolicy var1);

            public AccessPolicy.UpdateDefinitionStages.Blank<Update> defineAccessPolicy();

            public AccessPolicy.Update updateAccessPolicy(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Vault>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSku,
        WithNetworkRuleSet,
        WithConfigurations,
        WithAccessPolicy {
        }

        public static interface WithConfigurations {
            public WithCreate withDeploymentEnabled();

            public WithCreate withDiskEncryptionEnabled();

            public WithCreate withTemplateDeploymentEnabled();

            public WithCreate withSoftDeleteEnabled();

            public WithCreate withPurgeProtectionEnabled();

            public WithCreate withDeploymentDisabled();

            public WithCreate withDiskEncryptionDisabled();

            public WithCreate withTemplateDeploymentDisabled();
        }

        public static interface WithNetworkRuleSet {
            public WithCreate withAccessFromAllNetworks();

            public WithCreate withAccessFromSelectedNetworks();

            public WithCreate withAccessFromIpAddress(String var1);

            public WithCreate withAccessFromIpAddressRange(String var1);

            public WithCreate withAccessFromAzureServices();

            public WithCreate withBypass(NetworkRuleBypassOptions var1);

            public WithCreate withDefaultAction(NetworkRuleAction var1);

            public WithCreate withVirtualNetworkRules(List<VirtualNetworkRule> var1);
        }

        public static interface WithAccessPolicy {
            public WithCreate withEmptyAccessPolicy();

            public WithCreate withAccessPolicy(AccessPolicy var1);

            public AccessPolicy.DefinitionStages.Blank<WithCreate> defineAccessPolicy();
        }

        public static interface WithSku {
            public WithCreate withSku(SkuName var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithAccessPolicy> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithAccessPolicy,
    DefinitionStages.WithCreate {
    }
}

