/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.Key;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class KeyImpl
extends CreatableUpdatableImpl<Key, KeyProperties, KeyImpl>
implements Key,
Key.Definition,
Key.UpdateWithCreate,
Key.UpdateWithImport {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final Vault vault;
    private CreateKeyOptions createKeyRequest;
    private UpdateKeyOptions updateKeyRequest;
    private ImportKeyOptions importKeyRequest = null;
    private CryptographyAsyncClient cryptographyClient;
    private JsonWebKey jsonWebKey;

    private CryptographyAsyncClient cryptographyClient() {
        return this.cryptographyClient;
    }

    KeyImpl(String name, KeyProperties innerObject, Vault vault) {
        super(name, (Object)innerObject);
        this.vault = vault;
    }

    KeyImpl(String name, KeyVaultKey keyVaultKey, Vault vault) {
        super(name, (Object)keyVaultKey.getProperties());
        this.jsonWebKey = keyVaultKey.getKey();
        this.vault = vault;
    }

    private void init(boolean createNewCryptographyClient) {
        this.createKeyRequest = null;
        this.updateKeyRequest = new UpdateKeyOptions();
        if (this.innerModel() != null) {
            this.updateKeyRequest.keyProperties = (KeyProperties)this.innerModel();
            if (createNewCryptographyClient) {
                this.cryptographyClient = new CryptographyClientBuilder().keyIdentifier(((KeyProperties)this.innerModel()).getId()).pipeline(this.vault.vaultHttpPipeline()).buildAsyncClient();
            }
        }
    }

    private KeyImpl wrapModel(KeyProperties keyProperties) {
        return new KeyImpl(keyProperties.getName(), keyProperties, this.vault);
    }

    public String id() {
        return ((KeyProperties)this.innerModel()).getId();
    }

    @Override
    public JsonWebKey getJsonWebKey() {
        return (JsonWebKey)this.getJsonWebKeyAsync().block();
    }

    @Override
    public Mono<JsonWebKey> getJsonWebKeyAsync() {
        if (this.jsonWebKey != null) {
            return Mono.just((Object)this.jsonWebKey);
        }
        return this.getInnerAsync().map(ignored -> this.jsonWebKey);
    }

    @Override
    public KeyProperties attributes() {
        return (KeyProperties)this.innerModel();
    }

    @Override
    public Map<String, String> tags() {
        return ((KeyProperties)this.innerModel()).getTags();
    }

    @Override
    public boolean managed() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((KeyProperties)this.innerModel()).isManaged());
    }

    @Override
    public PagedIterable<Key> listVersions() {
        return new PagedIterable(this.listVersionsAsync());
    }

    @Override
    public PagedFlux<Key> listVersionsAsync() {
        return this.vault.keyClient().listPropertiesOfKeyVersions(this.name()).mapPage(this::wrapModel);
    }

    @Override
    public byte[] backup() {
        return (byte[])this.backupAsync().block();
    }

    @Override
    public Mono<byte[]> backupAsync() {
        return this.vault.keyClient().backupKey(this.name());
    }

    @Override
    public byte[] encrypt(EncryptionAlgorithm algorithm, byte[] content) {
        return (byte[])this.encryptAsync(algorithm, content).block();
    }

    @Override
    public Mono<byte[]> encryptAsync(EncryptionAlgorithm algorithm, byte[] content) {
        return this.cryptographyClient().encrypt(algorithm, content).map(EncryptResult::getCipherText);
    }

    @Override
    public byte[] decrypt(EncryptionAlgorithm algorithm, byte[] content) {
        return (byte[])this.decryptAsync(algorithm, content).block();
    }

    @Override
    public Mono<byte[]> decryptAsync(EncryptionAlgorithm algorithm, byte[] content) {
        return this.cryptographyClient().decrypt(algorithm, content).map(DecryptResult::getPlainText);
    }

    @Override
    public byte[] sign(SignatureAlgorithm algorithm, byte[] digest) {
        return (byte[])this.signAsync(algorithm, digest).block();
    }

    @Override
    public Mono<byte[]> signAsync(SignatureAlgorithm algorithm, byte[] digest) {
        return this.cryptographyClient().sign(algorithm, digest).map(SignResult::getSignature);
    }

    @Override
    public boolean verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((Boolean)this.verifyAsync(algorithm, digest, signature).block()));
    }

    @Override
    public Mono<Boolean> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.cryptographyClient().verify(algorithm, digest, signature).map(VerifyResult::isValid);
    }

    @Override
    public byte[] wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        return (byte[])this.wrapKeyAsync(algorithm, key).block();
    }

    @Override
    public Mono<byte[]> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key) {
        return this.cryptographyClient().wrapKey(algorithm, key).map(WrapResult::getEncryptedKey);
    }

    @Override
    public byte[] unwrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        return (byte[])this.unwrapKeyAsync(algorithm, key).block();
    }

    @Override
    public Mono<byte[]> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key) {
        return this.cryptographyClient().unwrapKey(algorithm, key).map(UnwrapResult::getKey);
    }

    protected Mono<KeyProperties> getInnerAsync() {
        return this.vault.keyClient().getKey(this.name()).map(keyVaultKey -> {
            this.jsonWebKey = keyVaultKey.getKey();
            return keyVaultKey.getProperties();
        });
    }

    @Override
    public KeyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            if (this.createKeyRequest != null) {
                this.createKeyRequest.setTags(tags);
            } else if (this.importKeyRequest != null) {
                this.importKeyRequest.setTags(tags);
            }
        } else {
            this.updateKeyRequest.keyProperties.setTags(tags);
        }
        return this;
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<Key> createResourceAsync() {
        Mono mono = this.createKeyRequest != null ? (this.createKeyRequest instanceof CreateEcKeyOptions ? this.vault.keyClient().createEcKey((CreateEcKeyOptions)this.createKeyRequest) : (this.createKeyRequest instanceof CreateRsaKeyOptions ? this.vault.keyClient().createRsaKey((CreateRsaKeyOptions)this.createKeyRequest) : this.vault.keyClient().createKey(this.createKeyRequest))) : this.vault.keyClient().importKey(this.importKeyRequest);
        return mono.map(keyVaultKey -> {
            this.setInner(keyVaultKey.getProperties());
            this.jsonWebKey = keyVaultKey.getKey();
            this.init(true);
            return this;
        });
    }

    public Mono<Key> updateResourceAsync() {
        UpdateKeyOptions optionsToUpdate = this.updateKeyRequest;
        Mono mono = Mono.just((Object)this);
        if (this.createKeyRequest != null || this.importKeyRequest != null) {
            mono = this.createResourceAsync().then(Mono.fromCallable(() -> {
                this.updateKeyRequest.keyProperties.setEnabled(optionsToUpdate.keyProperties.isEnabled());
                this.updateKeyRequest.keyProperties.setExpiresOn(optionsToUpdate.keyProperties.getExpiresOn());
                this.updateKeyRequest.keyProperties.setNotBefore(optionsToUpdate.keyProperties.getNotBefore());
                this.updateKeyRequest.keyProperties.setTags(optionsToUpdate.keyProperties.getTags());
                this.updateKeyRequest.keyOperations = optionsToUpdate.keyOperations;
                return this;
            }));
        }
        return mono.then(this.vault.keyClient().updateKeyProperties(this.updateKeyRequest.keyProperties, this.updateKeyRequest.keyOperations.toArray(new KeyOperation[0])).map(keyVaultKey -> {
            this.setInner(keyVaultKey.getProperties());
            this.jsonWebKey = keyVaultKey.getKey();
            this.init(false);
            return this;
        }));
    }

    @Override
    public KeyImpl withAttributes(KeyProperties attributes) {
        if (this.isInCreateMode()) {
            if (this.createKeyRequest != null) {
                this.createKeyRequest.setEnabled(attributes.isEnabled());
                this.createKeyRequest.setExpiresOn(attributes.getExpiresOn());
                this.createKeyRequest.setNotBefore(attributes.getNotBefore());
                this.createKeyRequest.setTags(attributes.getTags());
            } else if (this.importKeyRequest != null) {
                this.importKeyRequest.setEnabled(attributes.isEnabled());
                this.importKeyRequest.setExpiresOn(attributes.getExpiresOn());
                this.importKeyRequest.setNotBefore(attributes.getNotBefore());
                this.importKeyRequest.setTags(attributes.getTags());
            }
        } else {
            this.updateKeyRequest.keyProperties.setEnabled(attributes.isEnabled());
            this.updateKeyRequest.keyProperties.setExpiresOn(attributes.getExpiresOn());
            this.updateKeyRequest.keyProperties.setNotBefore(attributes.getNotBefore());
            this.updateKeyRequest.keyProperties.setTags(attributes.getTags());
        }
        return this;
    }

    @Override
    public KeyImpl withKeyTypeToCreate(KeyType keyType) {
        if (keyType == KeyType.EC || keyType == KeyType.EC_HSM) {
            CreateEcKeyOptions request = new CreateEcKeyOptions(this.name());
            request.setHardwareProtected(Boolean.valueOf(keyType == KeyType.EC_HSM));
            this.createKeyRequest = request;
        } else if (keyType == KeyType.RSA || keyType == KeyType.RSA_HSM) {
            CreateRsaKeyOptions request = new CreateRsaKeyOptions(this.name());
            request.setHardwareProtected(Boolean.valueOf(keyType == KeyType.RSA_HSM));
            this.createKeyRequest = request;
        } else {
            this.createKeyRequest = new CreateKeyOptions(this.name(), keyType);
        }
        return this;
    }

    @Override
    public KeyImpl withLocalKeyToImport(JsonWebKey key) {
        if (this.importKeyRequest != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Not in import flow"));
        }
        this.importKeyRequest = new ImportKeyOptions(this.name(), key);
        return this;
    }

    @Override
    public KeyImpl withKeyOperations(List<KeyOperation> keyOperations) {
        if (this.isInCreateMode()) {
            this.createKeyRequest.setKeyOperations(keyOperations.toArray(new KeyOperation[0]));
        } else {
            this.updateKeyRequest.keyOperations = keyOperations;
        }
        return this;
    }

    @Override
    public KeyImpl withKeyOperations(KeyOperation ... keyOperations) {
        return this.withKeyOperations((List)Arrays.asList(keyOperations));
    }

    @Override
    public KeyImpl withHsm(boolean isHsm) {
        if (this.importKeyRequest == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Not in import flow"));
        }
        this.importKeyRequest.setHardwareProtected(Boolean.valueOf(isHsm));
        return this;
    }

    @Override
    public KeyImpl withKeySize(int size) {
        if (this.createKeyRequest instanceof CreateRsaKeyOptions) {
            ((CreateRsaKeyOptions)this.createKeyRequest).setKeySize(Integer.valueOf(size));
        }
        return this;
    }

    @Override
    public Key.DefinitionStages.WithCreate withKeyCurveName(KeyCurveName keyCurveName) {
        if (this.createKeyRequest instanceof CreateEcKeyOptions) {
            ((CreateEcKeyOptions)this.createKeyRequest).setCurveName(keyCurveName);
        }
        return this;
    }

    private static class UpdateKeyOptions {
        private KeyProperties keyProperties = new KeyProperties();
        private List<KeyOperation> keyOperations = new ArrayList<KeyOperation>();

        private UpdateKeyOptions() {
        }
    }
}

