/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.VaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class VaultInner
extends Resource {
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties", required=true)
    private VaultProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(VaultInner.class);

    public SystemData systemData() {
        return this.systemData;
    }

    public VaultProperties properties() {
        return this.properties;
    }

    public VaultInner withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

    public VaultInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VaultInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property properties in model VaultInner"));
        }
        this.properties().validate();
    }
}

