// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.keyvault.models.DeletedManagedHsmProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The DeletedManagedHsm model. */
@Fluent
public final class DeletedManagedHsmInner {
    /*
     * The Azure Resource Manager resource ID for the deleted managed HSM Pool.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The name of the managed HSM Pool.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The resource type of the managed HSM Pool.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Properties of the deleted managed HSM
     */
    @JsonProperty(value = "properties")
    private DeletedManagedHsmProperties properties;

    /**
     * Get the id property: The Azure Resource Manager resource ID for the deleted managed HSM Pool.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the managed HSM Pool.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The resource type of the managed HSM Pool.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the properties property: Properties of the deleted managed HSM.
     *
     * @return the properties value.
     */
    public DeletedManagedHsmProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the deleted managed HSM.
     *
     * @param properties the properties value to set.
     * @return the DeletedManagedHsmInner object itself.
     */
    public DeletedManagedHsmInner withProperties(DeletedManagedHsmProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
