// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateEndpointConnectionInner;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpointConnectionsPutResponse;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in MhsmPrivateEndpointConnectionsClient. */
public interface MhsmPrivateEndpointConnectionsClient {
    /**
     * The List operation gets information about the private endpoint connections associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of private endpoint connections associated with a managed HSM Pools as paginated response with
     *     {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MhsmPrivateEndpointConnectionInner> listByResourceAsync(String resourceGroupName, String name);

    /**
     * The List operation gets information about the private endpoint connections associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of private endpoint connections associated with a managed HSM Pools as paginated response with
     *     {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MhsmPrivateEndpointConnectionInner> listByResource(String resourceGroupName, String name);

    /**
     * The List operation gets information about the private endpoint connections associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of private endpoint connections associated with a managed HSM Pools as paginated response with
     *     {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MhsmPrivateEndpointConnectionInner> listByResource(
        String resourceGroupName, String name, Context context);

    /**
     * Gets the specified private endpoint connection associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified private endpoint connection associated with the managed HSM Pool along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MhsmPrivateEndpointConnectionInner>> getWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Gets the specified private endpoint connection associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified private endpoint connection associated with the managed HSM Pool on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MhsmPrivateEndpointConnectionInner> getAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Gets the specified private endpoint connection associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified private endpoint connection associated with the managed HSM Pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MhsmPrivateEndpointConnectionInner get(String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Gets the specified private endpoint connection associated with the managed HSM Pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.keyvault.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified private endpoint connection associated with the managed HSM Pool along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MhsmPrivateEndpointConnectionInner> getWithResponse(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Updates the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param properties The intended state of private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MhsmPrivateEndpointConnectionsPutResponse> putWithResponseAsync(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        MhsmPrivateEndpointConnectionInner properties);

    /**
     * Updates the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param properties The intended state of private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MhsmPrivateEndpointConnectionInner> putAsync(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        MhsmPrivateEndpointConnectionInner properties);

    /**
     * Updates the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param properties The intended state of private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MhsmPrivateEndpointConnectionInner put(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        MhsmPrivateEndpointConnectionInner properties);

    /**
     * Updates the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param properties The intended state of private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MhsmPrivateEndpointConnectionsPutResponse putWithResponse(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        MhsmPrivateEndpointConnectionInner properties,
        Context context);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<MhsmPrivateEndpointConnectionInner>, MhsmPrivateEndpointConnectionInner> beginDeleteAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MhsmPrivateEndpointConnectionInner>, MhsmPrivateEndpointConnectionInner> beginDelete(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MhsmPrivateEndpointConnectionInner>, MhsmPrivateEndpointConnectionInner> beginDelete(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MhsmPrivateEndpointConnectionInner> deleteAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MhsmPrivateEndpointConnectionInner delete(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Deletes the specified private endpoint connection associated with the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm
     *     pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return private endpoint connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MhsmPrivateEndpointConnectionInner delete(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);
}
